/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CURIE
implements OdfDataType {
    private String mCURIE;
    private static final Pattern curiePattern = Pattern.compile("^(([\\i-[:]][\\c-[:]]*)?:)?.+$");

    public CURIE(String curie) throws IllegalArgumentException {
        if (!CURIE.isValid(curie)) {
            throw new IllegalArgumentException("parameter is invalid for datatype CURIE");
        }
        this.mCURIE = curie;
    }

    public String toString() {
        return this.mCURIE;
    }

    public static CURIE valueOf(String stringValue) throws IllegalArgumentException {
        return new CURIE(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && curiePattern.matcher(stringValue).matches() && stringValue.length() >= 1;
    }
}

