/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.secondaryemails.SecondaryEmail;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.dropbox.core.v2.team.TeamMembershipType;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MemberProfile {
    protected final String teamMemberId;
    protected final String externalId;
    protected final String accountId;
    protected final String email;
    protected final boolean emailVerified;
    protected final List<SecondaryEmail> secondaryEmails;
    protected final TeamMemberStatus status;
    protected final Name name;
    protected final TeamMembershipType membershipType;
    protected final Date invitedOn;
    protected final Date joinedOn;
    protected final Date suspendedOn;
    protected final String persistentId;
    protected final Boolean isDirectoryRestricted;
    protected final String profilePhotoUrl;

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, String externalId, String accountId, List<SecondaryEmail> secondaryEmails, Date invitedOn, Date joinedOn, Date suspendedOn, String persistentId, Boolean isDirectoryRestricted, String profilePhotoUrl) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.externalId = externalId;
        if (accountId != null) {
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
        }
        this.accountId = accountId;
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        this.email = email;
        this.emailVerified = emailVerified;
        if (secondaryEmails != null) {
            for (SecondaryEmail x : secondaryEmails) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'secondaryEmails' is null");
            }
        }
        this.secondaryEmails = secondaryEmails;
        if (status == null) {
            throw new IllegalArgumentException("Required value for 'status' is null");
        }
        this.status = status;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (membershipType == null) {
            throw new IllegalArgumentException("Required value for 'membershipType' is null");
        }
        this.membershipType = membershipType;
        this.invitedOn = LangUtil.truncateMillis(invitedOn);
        this.joinedOn = LangUtil.truncateMillis(joinedOn);
        this.suspendedOn = LangUtil.truncateMillis(suspendedOn);
        this.persistentId = persistentId;
        this.isDirectoryRestricted = isDirectoryRestricted;
        this.profilePhotoUrl = profilePhotoUrl;
    }

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
        this(teamMemberId, email, emailVerified, status, name, membershipType, null, null, null, null, null, null, null, null, null);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    public TeamMemberStatus getStatus() {
        return this.status;
    }

    public Name getName() {
        return this.name;
    }

    public TeamMembershipType getMembershipType() {
        return this.membershipType;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public List<SecondaryEmail> getSecondaryEmails() {
        return this.secondaryEmails;
    }

    public Date getInvitedOn() {
        return this.invitedOn;
    }

    public Date getJoinedOn() {
        return this.joinedOn;
    }

    public Date getSuspendedOn() {
        return this.suspendedOn;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public Boolean getIsDirectoryRestricted() {
        return this.isDirectoryRestricted;
    }

    public String getProfilePhotoUrl() {
        return this.profilePhotoUrl;
    }

    public static Builder newBuilder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
        return new Builder(teamMemberId, email, emailVerified, status, name, membershipType);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.externalId, this.accountId, this.email, this.emailVerified, this.secondaryEmails, this.status, this.name, this.membershipType, this.invitedOn, this.joinedOn, this.suspendedOn, this.persistentId, this.isDirectoryRestricted, this.profilePhotoUrl});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberProfile other = (MemberProfile)obj;
            return !(this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.status != other.status && !this.status.equals(other.status) || this.name != other.name && !this.name.equals(other.name) || this.membershipType != other.membershipType && !this.membershipType.equals((Object)other.membershipType) || this.externalId != other.externalId && (this.externalId == null || !this.externalId.equals(other.externalId)) || this.accountId != other.accountId && (this.accountId == null || !this.accountId.equals(other.accountId)) || this.secondaryEmails != other.secondaryEmails && (this.secondaryEmails == null || !this.secondaryEmails.equals(other.secondaryEmails)) || this.invitedOn != other.invitedOn && (this.invitedOn == null || !this.invitedOn.equals(other.invitedOn)) || this.joinedOn != other.joinedOn && (this.joinedOn == null || !this.joinedOn.equals(other.joinedOn)) || this.suspendedOn != other.suspendedOn && (this.suspendedOn == null || !this.suspendedOn.equals(other.suspendedOn)) || this.persistentId != other.persistentId && (this.persistentId == null || !this.persistentId.equals(other.persistentId)) || this.isDirectoryRestricted != other.isDirectoryRestricted && (this.isDirectoryRestricted == null || !this.isDirectoryRestricted.equals(other.isDirectoryRestricted)) || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberProfile> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberProfile value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("email_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.emailVerified, g);
            g.writeFieldName("status");
            TeamMemberStatus.Serializer.INSTANCE.serialize(value.status, g);
            g.writeFieldName("name");
            Name.Serializer.INSTANCE.serialize(value.name, g);
            g.writeFieldName("membership_type");
            TeamMembershipType.Serializer.INSTANCE.serialize(value.membershipType, g);
            if (value.externalId != null) {
                g.writeFieldName("external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.externalId, g);
            }
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (value.secondaryEmails != null) {
                g.writeFieldName("secondary_emails");
                StoneSerializers.nullable(StoneSerializers.list(SecondaryEmail.Serializer.INSTANCE)).serialize(value.secondaryEmails, g);
            }
            if (value.invitedOn != null) {
                g.writeFieldName("invited_on");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.invitedOn, g);
            }
            if (value.joinedOn != null) {
                g.writeFieldName("joined_on");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.joinedOn, g);
            }
            if (value.suspendedOn != null) {
                g.writeFieldName("suspended_on");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.suspendedOn, g);
            }
            if (value.persistentId != null) {
                g.writeFieldName("persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.persistentId, g);
            }
            if (value.isDirectoryRestricted != null) {
                g.writeFieldName("is_directory_restricted");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isDirectoryRestricted, g);
            }
            if (value.profilePhotoUrl != null) {
                g.writeFieldName("profile_photo_url");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.profilePhotoUrl, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberProfile deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_profilePhotoUrl;
            Boolean f_isDirectoryRestricted;
            String f_persistentId;
            Date f_suspendedOn;
            Date f_joinedOn;
            Date f_invitedOn;
            List<SecondaryEmail> f_secondaryEmails;
            String f_accountId;
            String f_externalId;
            TeamMembershipType f_membershipType;
            Name f_name;
            TeamMemberStatus f_status;
            Boolean f_emailVerified;
            String f_email;
            String f_teamMemberId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamMemberId = null;
                f_email = null;
                f_emailVerified = null;
                f_status = null;
                f_name = null;
                f_membershipType = null;
                f_externalId = null;
                f_accountId = null;
                f_secondaryEmails = null;
                f_invitedOn = null;
                f_joinedOn = null;
                f_suspendedOn = null;
                f_persistentId = null;
                f_isDirectoryRestricted = null;
                f_profilePhotoUrl = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("status".equals(field)) {
                        f_status = TeamMemberStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = (Name)Name.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("membership_type".equals(field)) {
                        f_membershipType = TeamMembershipType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("external_id".equals(field)) {
                        f_externalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("secondary_emails".equals(field)) {
                        f_secondaryEmails = StoneSerializers.nullable(StoneSerializers.list(SecondaryEmail.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("invited_on".equals(field)) {
                        f_invitedOn = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("joined_on".equals(field)) {
                        f_joinedOn = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("suspended_on".equals(field)) {
                        f_suspendedOn = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("persistent_id".equals(field)) {
                        f_persistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_directory_restricted".equals(field)) {
                        f_isDirectoryRestricted = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("profile_photo_url".equals(field)) {
                        f_profilePhotoUrl = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_emailVerified == null) {
                    throw new JsonParseException(p, "Required field \"email_verified\" missing.");
                }
                if (f_status == null) {
                    throw new JsonParseException(p, "Required field \"status\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_membershipType == null) {
                    throw new JsonParseException(p, "Required field \"membership_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberProfile value = new MemberProfile(f_teamMemberId, f_email, f_emailVerified, f_status, f_name, f_membershipType, f_externalId, f_accountId, f_secondaryEmails, f_invitedOn, f_joinedOn, f_suspendedOn, f_persistentId, f_isDirectoryRestricted, f_profilePhotoUrl);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String teamMemberId;
        protected final String email;
        protected final boolean emailVerified;
        protected final TeamMemberStatus status;
        protected final Name name;
        protected final TeamMembershipType membershipType;
        protected String externalId;
        protected String accountId;
        protected List<SecondaryEmail> secondaryEmails;
        protected Date invitedOn;
        protected Date joinedOn;
        protected Date suspendedOn;
        protected String persistentId;
        protected Boolean isDirectoryRestricted;
        protected String profilePhotoUrl;

        protected Builder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
            if (teamMemberId == null) {
                throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
            }
            this.teamMemberId = teamMemberId;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            if (status == null) {
                throw new IllegalArgumentException("Required value for 'status' is null");
            }
            this.status = status;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (membershipType == null) {
                throw new IllegalArgumentException("Required value for 'membershipType' is null");
            }
            this.membershipType = membershipType;
            this.externalId = null;
            this.accountId = null;
            this.secondaryEmails = null;
            this.invitedOn = null;
            this.joinedOn = null;
            this.suspendedOn = null;
            this.persistentId = null;
            this.isDirectoryRestricted = null;
            this.profilePhotoUrl = null;
        }

        public Builder withExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder withAccountId(String accountId) {
            if (accountId != null) {
                if (accountId.length() < 40) {
                    throw new IllegalArgumentException("String 'accountId' is shorter than 40");
                }
                if (accountId.length() > 40) {
                    throw new IllegalArgumentException("String 'accountId' is longer than 40");
                }
            }
            this.accountId = accountId;
            return this;
        }

        public Builder withSecondaryEmails(List<SecondaryEmail> secondaryEmails) {
            if (secondaryEmails != null) {
                for (SecondaryEmail x : secondaryEmails) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'secondaryEmails' is null");
                }
            }
            this.secondaryEmails = secondaryEmails;
            return this;
        }

        public Builder withInvitedOn(Date invitedOn) {
            this.invitedOn = LangUtil.truncateMillis(invitedOn);
            return this;
        }

        public Builder withJoinedOn(Date joinedOn) {
            this.joinedOn = LangUtil.truncateMillis(joinedOn);
            return this;
        }

        public Builder withSuspendedOn(Date suspendedOn) {
            this.suspendedOn = LangUtil.truncateMillis(suspendedOn);
            return this;
        }

        public Builder withPersistentId(String persistentId) {
            this.persistentId = persistentId;
            return this;
        }

        public Builder withIsDirectoryRestricted(Boolean isDirectoryRestricted) {
            this.isDirectoryRestricted = isDirectoryRestricted;
            return this;
        }

        public Builder withProfilePhotoUrl(String profilePhotoUrl) {
            this.profilePhotoUrl = profilePhotoUrl;
            return this;
        }

        public MemberProfile build() {
            return new MemberProfile(this.teamMemberId, this.email, this.emailVerified, this.status, this.name, this.membershipType, this.externalId, this.accountId, this.secondaryEmails, this.invitedOn, this.joinedOn, this.suspendedOn, this.persistentId, this.isDirectoryRestricted, this.profilePhotoUrl);
        }
    }
}

