/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_GcsUtil_CreateOptions;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_GcsUtil_StorageObjectOrIOException;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystemUtils;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GcsUtil.class);
    private static final long MAX_LIST_ITEMS_PER_CALL = 1024L;
    private static final Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private static final int MAX_REQUESTS_PER_BATCH = 100;
    private static final int MAX_CONCURRENT_BATCHES = 256;
    private static final FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(10).withInitialBackoff(Duration.standardSeconds((long)1L));
    private Storage storageClient;
    private Supplier<BatchInterface> batchRequestSupplier;
    private final HttpRequestInitializer httpRequestInitializer;
    private final @Nullable Integer uploadBufferSizeBytes;
    private final ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    final ExecutorService executorService;
    private Credentials credentials;
    private GoogleCloudStorage googleCloudStorage;
    private GoogleCloudStorageOptions googleCloudStorageOptions;
    @VisibleForTesting
    @Nullable Long maxBytesRewrittenPerCall;
    @VisibleForTesting
    @Nullable AtomicInteger numRewriteTokensUsed;

    public static String getNonWildcardPrefix(String globExp) {
        Matcher m = GLOB_PREFIX.matcher(globExp);
        Preconditions.checkArgument((boolean)m.matches(), (Object)String.format("Glob expression: [%s] is not expandable.", globExp));
        return m.group("PREFIX");
    }

    public static boolean isWildcard(GcsPath spec) {
        return GLOB_PREFIX.matcher(spec.getObject()).matches();
    }

    @VisibleForTesting
    GcsUtil(Storage storageClient, HttpRequestInitializer httpRequestInitializer, ExecutorService executorService, Boolean shouldUseGrpc, Credentials credentials, @Nullable Integer uploadBufferSizeBytes) {
        this.storageClient = storageClient;
        this.httpRequestInitializer = httpRequestInitializer;
        this.uploadBufferSizeBytes = uploadBufferSizeBytes;
        this.executorService = executorService;
        this.credentials = credentials;
        this.maxBytesRewrittenPerCall = null;
        this.numRewriteTokensUsed = null;
        this.googleCloudStorageOptions = GoogleCloudStorageOptions.builder().setAppName("Beam").setGrpcEnabled(shouldUseGrpc.booleanValue()).build();
        this.googleCloudStorage = this.createGoogleCloudStorage(this.googleCloudStorageOptions, storageClient, credentials);
        this.batchRequestSupplier = () -> {
            final GcsUtil util = this;
            return new BatchInterface(){
                final BatchRequest batch;
                {
                    this.batch = util.storageClient.batch(util.httpRequestInitializer);
                }

                @Override
                public <T> void queue(AbstractGoogleJsonClientRequest<T> request, JsonBatchCallback<T> cb) throws IOException {
                    request.queue(this.batch, cb);
                }

                @Override
                public void execute() throws IOException {
                    this.batch.execute();
                }

                @Override
                public int size() {
                    return this.batch.size();
                }
            };
        };
    }

    protected void setStorageClient(Storage storageClient) {
        this.storageClient = storageClient;
    }

    protected void setBatchRequestSupplier(Supplier<BatchInterface> supplier) {
        this.batchRequestSupplier = supplier;
    }

    public List<GcsPath> expand(GcsPath gcsPattern) throws IOException {
        Objects objects;
        Pattern p = null;
        String prefix = null;
        if (!GcsUtil.isWildcard(gcsPattern)) {
            try {
                this.getObject(gcsPattern);
                return ImmutableList.of((Object)gcsPattern);
            }
            catch (FileNotFoundException e) {
                return ImmutableList.of();
            }
        }
        prefix = GcsUtil.getNonWildcardPrefix(gcsPattern.getObject());
        p = Pattern.compile(FileSystemUtils.wildcardToRegexp((String)gcsPattern.getObject()));
        LOG.debug("matching files in bucket {}, prefix {} against pattern {}", new Object[]{gcsPattern.getBucket(), prefix, p.toString()});
        String pageToken = null;
        ArrayList<GcsPath> results = new ArrayList<GcsPath>();
        while ((objects = this.listObjects(gcsPattern.getBucket(), prefix, pageToken)).getItems() != null) {
            for (StorageObject o : objects.getItems()) {
                String name = o.getName();
                if (!p.matcher(name).matches() || name.endsWith("/")) continue;
                LOG.debug("Matched object: {}", (Object)name);
                results.add(GcsPath.fromObject(o));
            }
            pageToken = objects.getNextPageToken();
            if (pageToken != null) continue;
        }
        return results;
    }

    @VisibleForTesting
    @Nullable Integer getUploadBufferSizeBytes() {
        return this.uploadBufferSizeBytes;
    }

    private static BackOff createBackOff() {
        return BackOffAdapter.toGcpBackOff(BACKOFF_FACTORY.backoff());
    }

    public long fileSize(GcsPath path) throws IOException {
        return this.getObject(path).getSize().longValue();
    }

    public StorageObject getObject(GcsPath gcsPath) throws IOException {
        return this.getObject(gcsPath, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    StorageObject getObject(GcsPath gcsPath, BackOff backoff, Sleeper sleeper) throws IOException {
        Storage.Objects.Get getObject = this.storageClient.objects().get(gcsPath.getBucket(), gcsPath.getObject());
        try {
            return (StorageObject)ResilientOperation.retry(() -> ((Storage.Objects.Get)getObject).execute(), (BackOff)backoff, (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (e instanceof IOException && this.errorExtractor.itemNotFound((IOException)e)) {
                throw new FileNotFoundException(gcsPath.toString());
            }
            throw new IOException(String.format("Unable to get the file object for path %s.", gcsPath), e);
        }
    }

    public List<StorageObjectOrIOException> getObjects(List<GcsPath> gcsPaths) throws IOException {
        if (gcsPaths.isEmpty()) {
            return ImmutableList.of();
        }
        if (gcsPaths.size() == 1) {
            GcsPath path = gcsPaths.get(0);
            try {
                StorageObject object = this.getObject(path);
                return ImmutableList.of((Object)StorageObjectOrIOException.create(object));
            }
            catch (IOException e) {
                return ImmutableList.of((Object)StorageObjectOrIOException.create(e));
            }
            catch (Exception e) {
                IOException ioException = new IOException(String.format("Error trying to get %s: %s", path, e));
                return ImmutableList.of((Object)StorageObjectOrIOException.create(ioException));
            }
        }
        ArrayList<StorageObjectOrIOException[]> results = new ArrayList<StorageObjectOrIOException[]>();
        GcsUtil.executeBatches(this.makeGetBatches(gcsPaths, results));
        ImmutableList.Builder ret = ImmutableList.builder();
        for (StorageObjectOrIOException[] result : results) {
            ret.add((Object)result[0]);
        }
        return ret.build();
    }

    public Objects listObjects(String bucket, String prefix, @Nullable String pageToken) throws IOException {
        return this.listObjects(bucket, prefix, pageToken, null);
    }

    public Objects listObjects(String bucket, String prefix, @Nullable String pageToken, @Nullable String delimiter) throws IOException {
        Storage.Objects.List listObject = this.storageClient.objects().list(bucket);
        listObject.setMaxResults(Long.valueOf(1024L));
        listObject.setPrefix(prefix);
        listObject.setDelimiter(delimiter);
        if (pageToken != null) {
            listObject.setPageToken(pageToken);
        }
        try {
            return (Objects)ResilientOperation.retry(() -> ((Storage.Objects.List)listObject).execute(), (BackOff)GcsUtil.createBackOff(), (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to match files in bucket %s, prefix %s.", bucket, prefix), e);
        }
    }

    @VisibleForTesting
    List<Long> fileSizes(List<GcsPath> paths) throws IOException {
        List<StorageObjectOrIOException> results = this.getObjects(paths);
        ImmutableList.Builder ret = ImmutableList.builder();
        for (StorageObjectOrIOException result : results) {
            ret.add((Object)this.toFileSize(result));
        }
        return ret.build();
    }

    private Long toFileSize(StorageObjectOrIOException storageObjectOrIOException) throws IOException {
        if (storageObjectOrIOException.ioException() != null) {
            throw storageObjectOrIOException.ioException();
        }
        return storageObjectOrIOException.storageObject().getSize().longValue();
    }

    @VisibleForTesting
    void setCloudStorageImpl(GoogleCloudStorage g) {
        this.googleCloudStorage = g;
    }

    @VisibleForTesting
    void setCloudStorageImpl(GoogleCloudStorageOptions g) {
        this.googleCloudStorageOptions = g;
    }

    public SeekableByteChannel open(GcsPath path) throws IOException {
        return this.googleCloudStorage.open(new StorageResourceId(path.getBucket(), path.getObject()));
    }

    @VisibleForTesting
    SeekableByteChannel open(GcsPath path, GoogleCloudStorageReadOptions readOptions) throws IOException {
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Storage");
        baseLabels.put("METHOD", "GcsGet");
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.cloudStorageBucket((String)path.getBucket()));
        baseLabels.put("GCS_PROJECT_ID", String.valueOf(this.googleCloudStorageOptions.getProjectId()));
        baseLabels.put("GCS_BUCKET", path.getBucket());
        ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        try {
            SeekableByteChannel channel = this.googleCloudStorage.open(new StorageResourceId(path.getBucket(), path.getObject()), readOptions);
            serviceCallMetric.call("ok");
            return channel;
        }
        catch (IOException e) {
            if (e.getCause() instanceof GoogleJsonResponseException) {
                serviceCallMetric.call(((GoogleJsonResponseException)e.getCause()).getDetails().getCode());
            }
            throw e;
        }
    }

    @Deprecated
    public WritableByteChannel create(GcsPath path, String type) throws IOException {
        CreateOptions.Builder builder = CreateOptions.builder().setContentType(type);
        return this.create(path, builder.build());
    }

    @Deprecated
    public WritableByteChannel create(GcsPath path, String type, Integer uploadBufferSizeBytes) throws IOException {
        CreateOptions.Builder builder = CreateOptions.builder().setContentType(type).setUploadBufferSizeBytes(uploadBufferSizeBytes);
        return this.create(path, builder.build());
    }

    public WritableByteChannel create(GcsPath path, CreateOptions options) throws IOException {
        Integer uploadBufferSizeBytes;
        AsyncWriteChannelOptions wcOptions = this.googleCloudStorageOptions.getWriteChannelOptions();
        Integer n = uploadBufferSizeBytes = options.getUploadBufferSizeBytes() != null ? options.getUploadBufferSizeBytes() : this.getUploadBufferSizeBytes();
        if (uploadBufferSizeBytes != null) {
            wcOptions = wcOptions.toBuilder().setUploadChunkSize(uploadBufferSizeBytes.intValue()).build();
        }
        GoogleCloudStorageOptions newGoogleCloudStorageOptions = this.googleCloudStorageOptions.toBuilder().setWriteChannelOptions(wcOptions).build();
        GoogleCloudStorage gcpStorage = this.createGoogleCloudStorage(newGoogleCloudStorageOptions, this.storageClient, this.credentials);
        StorageResourceId resourceId = new StorageResourceId(path.getBucket(), path.getObject(), options.getExpectFileToNotExist() ? 0L : -1L);
        CreateObjectOptions.Builder createBuilder = CreateObjectOptions.builder().setOverwriteExisting(true);
        if (options.getContentType() != null) {
            createBuilder = createBuilder.setContentType(options.getContentType());
        }
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Storage");
        baseLabels.put("METHOD", "GcsInsert");
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.cloudStorageBucket((String)path.getBucket()));
        baseLabels.put("GCS_PROJECT_ID", String.valueOf(this.googleCloudStorageOptions.getProjectId()));
        baseLabels.put("GCS_BUCKET", path.getBucket());
        ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        try {
            WritableByteChannel channel = gcpStorage.create(resourceId, createBuilder.build());
            serviceCallMetric.call("ok");
            return channel;
        }
        catch (IOException e) {
            if (e.getCause() instanceof GoogleJsonResponseException) {
                serviceCallMetric.call(((GoogleJsonResponseException)e.getCause()).getDetails().getCode());
            }
            throw e;
        }
    }

    GoogleCloudStorage createGoogleCloudStorage(GoogleCloudStorageOptions options, Storage storage, Credentials credentials) {
        return new GoogleCloudStorageImpl(options, storage, credentials);
    }

    public void verifyBucketAccessible(GcsPath path) throws IOException {
        this.verifyBucketAccessible(path, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public boolean bucketAccessible(GcsPath path) throws IOException {
        return this.bucketAccessible(path, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    public long bucketOwner(GcsPath path) throws IOException {
        return this.getBucket(path, GcsUtil.createBackOff(), Sleeper.DEFAULT).getProjectNumber().longValue();
    }

    public void createBucket(String projectId, Bucket bucket) throws IOException {
        this.createBucket(projectId, bucket, GcsUtil.createBackOff(), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    boolean bucketAccessible(GcsPath path, BackOff backoff, Sleeper sleeper) throws IOException {
        try {
            return this.getBucket(path, backoff, sleeper) != null;
        }
        catch (FileNotFoundException | AccessDeniedException e) {
            return false;
        }
    }

    @VisibleForTesting
    void verifyBucketAccessible(GcsPath path, BackOff backoff, Sleeper sleeper) throws IOException {
        this.getBucket(path, backoff, sleeper);
    }

    @VisibleForTesting
    @Nullable Bucket getBucket(GcsPath path, BackOff backoff, Sleeper sleeper) throws IOException {
        Storage.Buckets.Get getBucket = this.storageClient.buckets().get(path.getBucket());
        try {
            return (Bucket)ResilientOperation.retry(() -> ((Storage.Buckets.Get)getBucket).execute(), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public boolean shouldRetry(IOException e) {
                    if (GcsUtil.this.errorExtractor.itemNotFound(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.accessDenied((IOException)((Object)e))) {
                throw new AccessDeniedException(path.toString(), null, e.getMessage());
            }
            if (this.errorExtractor.itemNotFound((IOException)((Object)e))) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Error while attempting to verify existence of bucket gs://%s", path.getBucket()), e);
        }
    }

    @VisibleForTesting
    void createBucket(String projectId, Bucket bucket, BackOff backoff, Sleeper sleeper) throws IOException {
        Storage.Buckets.Insert insertBucket = this.storageClient.buckets().insert(projectId, bucket);
        insertBucket.setPredefinedAcl("projectPrivate");
        insertBucket.setPredefinedDefaultObjectAcl("projectPrivate");
        try {
            ResilientOperation.retry(() -> ((Storage.Buckets.Insert)insertBucket).execute(), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public boolean shouldRetry(IOException e) {
                    if (GcsUtil.this.errorExtractor.itemAlreadyExists(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
            return;
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.accessDenied((IOException)((Object)e))) {
                throw new AccessDeniedException(bucket.getName(), null, e.getMessage());
            }
            if (this.errorExtractor.itemAlreadyExists((IOException)((Object)e))) {
                throw new FileAlreadyExistsException(bucket.getName(), null, e.getMessage());
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Error while attempting to create bucket gs://%s for project %s", bucket.getName(), projectId), e);
        }
    }

    private static void executeBatches(List<BatchInterface> batches) throws IOException {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(256, 256, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (BatchInterface batch : batches) {
            futures.add(MoreFutures.runAsync(batch::execute, (ExecutorService)executor));
        }
        try {
            MoreFutures.get((CompletionStage)MoreFutures.allAsList(futures));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while executing batch GCS request", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw new IOException("Error executing batch GCS request", e);
        }
        finally {
            executor.shutdown();
        }
    }

    @VisibleForTesting
    List<BatchInterface> makeGetBatches(Collection<GcsPath> paths, List<StorageObjectOrIOException[]> results) throws IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        for (List filesToGet : Lists.partition((List)Lists.newArrayList(paths), (int)100)) {
            BatchInterface batch = this.batchRequestSupplier.get();
            for (GcsPath path : filesToGet) {
                results.add(this.enqueueGetFileSize(path, batch));
            }
            batches.add(batch);
        }
        return batches;
    }

    public void copy(Iterable<String> srcFilenames, Iterable<String> destFilenames) throws IOException {
        this.rewriteHelper(srcFilenames, destFilenames, false, false, false);
    }

    public void rename(Iterable<String> srcFilenames, Iterable<String> destFilenames, MoveOptions ... moveOptions) throws IOException {
        HashSet moveOptionSet = Sets.newHashSet((Object[])moveOptions);
        boolean ignoreMissingSrc = moveOptionSet.contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
        boolean ignoreExistingDest = moveOptionSet.contains(MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
        this.rewriteHelper(srcFilenames, destFilenames, true, ignoreMissingSrc, ignoreExistingDest);
    }

    private void rewriteHelper(Iterable<String> srcFilenames, Iterable<String> destFilenames, boolean deleteSource, boolean ignoreMissingSource, boolean ignoreExistingDest) throws IOException {
        List<BatchInterface> batches;
        LinkedList<RewriteOp> rewrites = this.makeRewriteOps(srcFilenames, destFilenames, deleteSource, ignoreMissingSource, ignoreExistingDest);
        org.apache.beam.sdk.util.BackOff backoff = BACKOFF_FACTORY.backoff();
        while (!(batches = this.makeRewriteBatches(rewrites)).isEmpty()) {
            RewriteOp sampleErrorOp = rewrites.stream().filter(op -> op.getLastError() != null).findFirst().orElse(null);
            if (sampleErrorOp != null) {
                long backOffMillis = backoff.nextBackOffMillis();
                if (backOffMillis == -1L) {
                    throw new IOException(String.format("Error completing file copies with retries, sample: from %s to %s due to %s", sampleErrorOp.getFrom().toString(), sampleErrorOp.getTo().toString(), sampleErrorOp.getLastError()));
                }
                LOG.warn("Retrying with backoff unsuccessful copy requests, sample request: from {} to {} due to {}", new Object[]{sampleErrorOp.getFrom(), sampleErrorOp.getTo(), sampleErrorOp.getLastError()});
                try {
                    Thread.sleep(backOffMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(String.format("Interrupted backoff of file copies with retries, sample: from %s to %s due to %s", sampleErrorOp.getFrom().toString(), sampleErrorOp.getTo().toString(), sampleErrorOp.getLastError()));
                }
            }
            GcsUtil.executeBatches(batches);
        }
    }

    LinkedList<RewriteOp> makeRewriteOps(Iterable<String> srcFilenames, Iterable<String> destFilenames, boolean deleteSource, boolean ignoreMissingSource, boolean ignoreExistingDest) throws IOException {
        ArrayList srcList = Lists.newArrayList(srcFilenames);
        ArrayList destList = Lists.newArrayList(destFilenames);
        Preconditions.checkArgument((srcList.size() == destList.size() ? 1 : 0) != 0, (String)"Number of source files %s must equal number of destination files %s", (int)srcList.size(), (int)destList.size());
        LinkedList rewrites = Lists.newLinkedList();
        for (int i = 0; i < srcList.size(); ++i) {
            GcsPath sourcePath = GcsPath.fromUri((String)srcList.get(i));
            GcsPath destPath = GcsPath.fromUri((String)destList.get(i));
            if (ignoreExistingDest && !sourcePath.getBucket().equals(destPath.getBucket())) {
                throw new UnsupportedOperationException("Skipping dest existence is only supported within a bucket.");
            }
            rewrites.addLast(new RewriteOp(sourcePath, destPath, deleteSource, ignoreMissingSource));
        }
        return rewrites;
    }

    List<BatchInterface> makeRewriteBatches(LinkedList<RewriteOp> rewrites) throws IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        BatchInterface batch = this.batchRequestSupplier.get();
        Iterator it = rewrites.iterator();
        while (it.hasNext()) {
            RewriteOp rewrite = (RewriteOp)((Object)it.next());
            if (!rewrite.getReadyToEnqueue()) {
                it.remove();
                continue;
            }
            rewrite.enqueue(batch);
            if (batch.size() < 100) continue;
            batches.add(batch);
            batch = this.batchRequestSupplier.get();
        }
        if (batch.size() > 0) {
            batches.add(batch);
        }
        return batches;
    }

    List<BatchInterface> makeRemoveBatches(Collection<String> filenames) throws IOException {
        ArrayList<BatchInterface> batches = new ArrayList<BatchInterface>();
        for (List filesToDelete : Lists.partition((List)Lists.newArrayList(filenames), (int)100)) {
            BatchInterface batch = this.batchRequestSupplier.get();
            for (String file : filesToDelete) {
                this.enqueueDelete(GcsPath.fromUri(file), batch);
            }
            batches.add(batch);
        }
        return batches;
    }

    public void remove(Collection<String> filenames) throws IOException {
        GcsUtil.executeBatches(this.makeRemoveBatches(filenames));
    }

    private StorageObjectOrIOException[] enqueueGetFileSize(final GcsPath path, BatchInterface batch) throws IOException {
        final StorageObjectOrIOException[] ret = new StorageObjectOrIOException[1];
        Storage.Objects.Get getRequest = this.storageClient.objects().get(path.getBucket(), path.getObject());
        batch.queue(getRequest, new JsonBatchCallback<StorageObject>(){

            public void onSuccess(StorageObject response, HttpHeaders httpHeaders) throws IOException {
                ret[0] = StorageObjectOrIOException.create(response);
            }

            public void onFailure(GoogleJsonError e, HttpHeaders httpHeaders) throws IOException {
                IOException ioException = e.getCode() == 404 ? new FileNotFoundException(path.toString()) : new IOException(String.format("Error trying to get %s: %s", path, e));
                ret[0] = StorageObjectOrIOException.create(ioException);
            }
        });
        return ret;
    }

    private void enqueueDelete(final GcsPath file, BatchInterface batch) throws IOException {
        Storage.Objects.Delete deleteRequest = this.storageClient.objects().delete(file.getBucket(), file.getObject());
        batch.queue(deleteRequest, new JsonBatchCallback<Void>(){

            public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                LOG.debug("Successfully deleted {}", (Object)file);
            }

            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                if (e.getCode() != 404) {
                    throw new IOException(String.format("Error trying to delete %s: %s", file, e));
                }
                LOG.info("Ignoring failed deletion of file {} which already does not exist: {}", (Object)file, (Object)e);
            }
        });
    }

    @VisibleForTesting
    static interface BatchInterface {
        public <T> void queue(AbstractGoogleJsonClientRequest<T> var1, JsonBatchCallback<T> var2) throws IOException;

        public void execute() throws IOException;

        public int size();
    }

    @SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"})
    @AutoValue
    public static abstract class StorageObjectOrIOException {
        public abstract @Nullable StorageObject storageObject();

        public abstract @Nullable IOException ioException();

        @VisibleForTesting
        public static StorageObjectOrIOException create(StorageObject storageObject) {
            return new AutoValue_GcsUtil_StorageObjectOrIOException((StorageObject)Preconditions.checkNotNull((Object)storageObject, (Object)"storageObject"), null);
        }

        @VisibleForTesting
        public static StorageObjectOrIOException create(IOException ioException) {
            return new AutoValue_GcsUtil_StorageObjectOrIOException(null, (IOException)Preconditions.checkNotNull((Object)ioException, (Object)"ioException"));
        }
    }

    class RewriteOp
    extends JsonBatchCallback<RewriteResponse> {
        private final GcsPath from;
        private final GcsPath to;
        private final boolean deleteSource;
        private final boolean ignoreMissingSource;
        private boolean readyToEnqueue;
        private boolean performDelete;
        private GoogleJsonError lastError;
        @VisibleForTesting
        Storage.Objects.Rewrite rewriteRequest;

        public boolean getReadyToEnqueue() {
            return this.readyToEnqueue;
        }

        public GoogleJsonError getLastError() {
            return this.lastError;
        }

        public GcsPath getFrom() {
            return this.from;
        }

        public GcsPath getTo() {
            return this.to;
        }

        public void enqueue(BatchInterface batch) throws IOException {
            if (!this.readyToEnqueue) {
                throw new IOException(String.format("Invalid state for Rewrite, from=%s, to=%s, readyToEnqueue=%s", this.from, this.to, this.readyToEnqueue));
            }
            if (this.performDelete) {
                Storage.Objects.Delete deleteRequest = GcsUtil.this.storageClient.objects().delete(this.from.getBucket(), this.from.getObject());
                batch.queue(deleteRequest, new JsonBatchCallback<Void>(){

                    public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                        LOG.debug("Successfully deleted {} after moving to {}", (Object)RewriteOp.this.from, (Object)RewriteOp.this.to);
                        RewriteOp.this.readyToEnqueue = false;
                        RewriteOp.this.lastError = null;
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                        if (e.getCode() == 404) {
                            LOG.info("Ignoring failed deletion of moved file {} which already does not exist: {}", (Object)RewriteOp.this.from, (Object)e);
                            RewriteOp.this.readyToEnqueue = false;
                            RewriteOp.this.lastError = null;
                        } else {
                            RewriteOp.this.readyToEnqueue = true;
                            RewriteOp.this.lastError = e;
                        }
                    }
                });
            } else {
                batch.queue(this.rewriteRequest, this);
            }
        }

        public RewriteOp(GcsPath from, GcsPath to, boolean deleteSource, boolean ignoreMissingSource) throws IOException {
            this.from = from;
            this.to = to;
            this.deleteSource = deleteSource;
            this.ignoreMissingSource = ignoreMissingSource;
            this.rewriteRequest = GcsUtil.this.storageClient.objects().rewrite(from.getBucket(), from.getObject(), to.getBucket(), to.getObject(), null);
            if (GcsUtil.this.maxBytesRewrittenPerCall != null) {
                this.rewriteRequest.setMaxBytesRewrittenPerCall(GcsUtil.this.maxBytesRewrittenPerCall);
            }
            this.readyToEnqueue = true;
        }

        public void onSuccess(RewriteResponse rewriteResponse, HttpHeaders responseHeaders) throws IOException {
            this.lastError = null;
            if (rewriteResponse.getDone().booleanValue()) {
                if (this.deleteSource) {
                    this.readyToEnqueue = true;
                    this.performDelete = true;
                } else {
                    this.readyToEnqueue = false;
                }
            } else {
                LOG.debug("Rewrite progress: {} of {} bytes, {} to {}", new Object[]{rewriteResponse.getTotalBytesRewritten(), rewriteResponse.getObjectSize(), this.from, this.to});
                this.rewriteRequest.setRewriteToken(rewriteResponse.getRewriteToken());
                this.readyToEnqueue = true;
                if (GcsUtil.this.numRewriteTokensUsed != null) {
                    GcsUtil.this.numRewriteTokensUsed.incrementAndGet();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
            if (e.getCode() == 404) {
                if (!this.ignoreMissingSource) throw new FileNotFoundException(String.format("Source %s not found. Failed with error: %s", this.from.toString(), e.getMessage()));
                this.readyToEnqueue = false;
                this.lastError = null;
                return;
            } else if (e.getCode() == 403 && e.getErrors().size() == 1 && ((GoogleJsonError.ErrorInfo)e.getErrors().get(0)).getReason().equals("retentionPolicyNotMet")) {
                List<StorageObjectOrIOException> srcAndDestObjects = GcsUtil.this.getObjects(Arrays.asList(this.from, this.to));
                String srcHash = srcAndDestObjects.get(0).storageObject().getMd5Hash();
                String destHash = srcAndDestObjects.get(1).storageObject().getMd5Hash();
                if (srcHash == null || !srcHash.equals(destHash)) throw new IOException(e.getMessage());
                LOG.warn("Caught retentionPolicyNotMet error while rewriting to a bucket with retention policy. Skipping because destination {} and source {} are considered identical because their MD5 Hashes are equal.", (Object)this.getFrom(), (Object)this.getTo());
                if (this.deleteSource) {
                    this.readyToEnqueue = true;
                    this.performDelete = true;
                } else {
                    this.readyToEnqueue = false;
                }
                this.lastError = null;
                return;
            } else {
                this.lastError = e;
                this.readyToEnqueue = true;
            }
        }
    }

    @AutoValue
    public static abstract class CreateOptions {
        public abstract boolean getExpectFileToNotExist();

        public abstract @Nullable Integer getUploadBufferSizeBytes();

        public abstract @Nullable String getContentType();

        public static Builder builder() {
            return new AutoValue_GcsUtil_CreateOptions.Builder().setExpectFileToNotExist(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setContentType(String var1);

            public abstract Builder setUploadBufferSizeBytes(int var1);

            public abstract Builder setExpectFileToNotExist(boolean var1);

            public abstract CreateOptions build();
        }
    }

    public static class GcsUtilFactory
    implements DefaultValueFactory<GcsUtil> {
        public GcsUtil create(PipelineOptions options) {
            LOG.debug("Creating new GcsUtil");
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            Storage.Builder storageBuilder = Transport.newStorageClient(gcsOptions);
            return new GcsUtil(storageBuilder.build(), storageBuilder.getHttpRequestInitializer(), gcsOptions.getExecutorService(), ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)"use_grpc_for_gcs"), gcsOptions.getGcpCredential(), gcsOptions.getGcsUploadBufferSizeBytes());
        }

        public static GcsUtil create(PipelineOptions options, Storage storageClient, HttpRequestInitializer httpRequestInitializer, ExecutorService executorService, Credentials credentials, @Nullable Integer uploadBufferSizeBytes) {
            return new GcsUtil(storageClient, httpRequestInitializer, executorService, ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)"use_grpc_for_gcs"), credentials, uploadBufferSizeBytes);
        }
    }
}

