/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CharStreams;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class GceMetadataUtil {
    private static final String BASE_METADATA_URL = "http://metadata/computeMetadata/v1/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String fetchMetadata(String key) {
        int timeoutMillis = 5000;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutMillis);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
        HttpGet request = new HttpGet(BASE_METADATA_URL + key);
        request.setHeader("Metadata-Flavor", "Google");
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                return "";
            }
            InputStream in = response.getEntity().getContent();
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private static String fetchCustomGceMetadata(String customMetadataKey) {
        return GceMetadataUtil.fetchMetadata("instance/attributes/" + customMetadataKey);
    }

    public static String fetchDataflowJobId() {
        return GceMetadataUtil.fetchCustomGceMetadata("job_id");
    }
}

