/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.io.Serializable;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.Preconditions;

public class TaskExecutorRegistration
implements Serializable {
    private static final long serialVersionUID = -5727832919954047964L;
    private final String taskExecutorAddress;
    private final ResourceID resourceId;
    private final int dataPort;
    private final int jmxPort;
    private final HardwareDescription hardwareDescription;
    private final TaskExecutorMemoryConfiguration memoryConfiguration;
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResourceProfile;

    public TaskExecutorRegistration(String taskExecutorAddress, ResourceID resourceId, int dataPort, int jmxPort, HardwareDescription hardwareDescription, TaskExecutorMemoryConfiguration memoryConfiguration, ResourceProfile defaultSlotResourceProfile, ResourceProfile totalResourceProfile) {
        this.taskExecutorAddress = (String)Preconditions.checkNotNull((Object)taskExecutorAddress);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.dataPort = dataPort;
        this.jmxPort = jmxPort;
        this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
        this.memoryConfiguration = (TaskExecutorMemoryConfiguration)Preconditions.checkNotNull((Object)memoryConfiguration);
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.totalResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)totalResourceProfile);
    }

    public String getTaskExecutorAddress() {
        return this.taskExecutorAddress;
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public TaskExecutorMemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }
}

