/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobKey;

@VisibleForTesting
public class VoidBlobWriter
implements BlobWriter {
    private static final VoidBlobWriter INSTANCE = new VoidBlobWriter();

    @Override
    public PermanentBlobKey putPermanent(JobID jobId, byte[] value) throws IOException {
        throw new IOException("The VoidBlobWriter cannot write data to the BLOB store.");
    }

    @Override
    public PermanentBlobKey putPermanent(JobID jobId, InputStream inputStream) throws IOException {
        throw new IOException("The VoidBlobWriter cannot write data to the BLOB store.");
    }

    @Override
    public boolean deletePermanent(JobID jobId, PermanentBlobKey key) {
        throw new UnsupportedOperationException("The VoidBlobWriter cannot delete data from the BLOB store.");
    }

    @Override
    public int getMinOffloadingSize() {
        return Integer.MAX_VALUE;
    }

    public static VoidBlobWriter getInstance() {
        return INSTANCE;
    }
}

