/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamlookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.streamlookup.StreamLookupMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StreamLookupDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = StreamLookupMeta.class;
    private CCombo wTransform;
    private TableView wKey;
    private TableView wReturn;
    private Button wPreserveMemory;
    private Button wSortedList;
    private Button wIntegerPair;
    private final StreamLookupMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;

    public StreamLookupDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (StreamLookupMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
                StreamLookupDialog.this.setComboBoxesLookup();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        StreamLookupDialog streamLookupDialog = this;
        int margin = streamLookupDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        Button wGetLU = new Button((Composite)this.shell, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.GetLookupFields.Button", (String[])new String[0]));
        wGetLU.addListener(13, e -> this.getlookup());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wGet, wGetLU}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlTransform = new Label((Composite)this.shell, 131072);
        wlTransform.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.LookupTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransform);
        FormData fdlTransform = new FormData();
        fdlTransform.left = new FormAttachment(0, 0);
        fdlTransform.right = new FormAttachment(middle, -margin);
        fdlTransform.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        wlTransform.setLayoutData((Object)fdlTransform);
        this.wTransform = new CCombo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransform);
        List previousTransforms = this.pipelineMeta.findPreviousTransforms(this.transformMeta, true);
        for (TransformMeta previousTransform : previousTransforms) {
            this.wTransform.add(previousTransform.getName());
        }
        this.wTransform.addModifyListener(lsMod);
        this.wTransform.addSelectionListener((SelectionListener)lsSelection);
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(middle, 0);
        fdTransform.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        fdTransform.right = new FormAttachment(100, 0);
        this.wTransform.setLayoutData((Object)fdTransform);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Key.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wTransform, margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getKeystream() != null ? this.input.getKeystream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.LookupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wKey = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.bottom = new FormAttachment((Control)wlKey, (int)(this.props.getZoomFactor() * 120.0));
        this.wKey.setLayoutData((Object)fdKey);
        Label wlSortedList = new Label((Composite)this.shell, 131072);
        wlSortedList.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.SortedList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSortedList);
        FormData fdlSortedList = new FormData();
        fdlSortedList.left = new FormAttachment(0, 0);
        fdlSortedList.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdlSortedList.right = new FormAttachment(middle, -margin);
        wlSortedList.setLayoutData((Object)fdlSortedList);
        this.wSortedList = new Button((Composite)this.shell, 16);
        this.wSortedList.setEnabled(false);
        PropsUi.setLook((Widget)this.wSortedList);
        FormData fdSortedList = new FormData();
        fdSortedList.left = new FormAttachment(middle, 0);
        fdSortedList.top = new FormAttachment((Control)wlSortedList, 0, 0x1000000);
        fdSortedList.right = new FormAttachment(100, 0);
        this.wSortedList.setLayoutData((Object)fdSortedList);
        this.wSortedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        Label wlIntegerPair = new Label((Composite)this.shell, 131072);
        wlIntegerPair.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.IntegerPair.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIntegerPair);
        FormData fdlIntegerPair = new FormData();
        fdlIntegerPair.left = new FormAttachment(0, 0);
        fdlIntegerPair.bottom = new FormAttachment((Control)this.wSortedList, -margin);
        fdlIntegerPair.right = new FormAttachment(middle, -margin);
        wlIntegerPair.setLayoutData((Object)fdlIntegerPair);
        this.wIntegerPair = new Button((Composite)this.shell, 16);
        this.wIntegerPair.setEnabled(false);
        PropsUi.setLook((Widget)this.wIntegerPair);
        FormData fdIntegerPair = new FormData();
        fdIntegerPair.left = new FormAttachment(middle, 0);
        fdIntegerPair.top = new FormAttachment((Control)wlIntegerPair, 0, 0x1000000);
        fdIntegerPair.right = new FormAttachment(100, 0);
        this.wIntegerPair.setLayoutData((Object)fdIntegerPair);
        this.wIntegerPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        Label wlPreserveMemory = new Label((Composite)this.shell, 131072);
        wlPreserveMemory.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PreserveMemory.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPreserveMemory);
        FormData fdlPreserveMemory = new FormData();
        fdlPreserveMemory.left = new FormAttachment(0, 0);
        fdlPreserveMemory.bottom = new FormAttachment((Control)wlIntegerPair, -margin);
        fdlPreserveMemory.right = new FormAttachment(middle, -margin);
        wlPreserveMemory.setLayoutData((Object)fdlPreserveMemory);
        this.wPreserveMemory = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wPreserveMemory);
        FormData fdPreserveMemory = new FormData();
        fdPreserveMemory.left = new FormAttachment(middle, 0);
        fdPreserveMemory.top = new FormAttachment((Control)wlPreserveMemory, 0, 0x1000000);
        fdPreserveMemory.right = new FormAttachment(100, 0);
        this.wPreserveMemory.setLayoutData((Object)fdPreserveMemory);
        this.wPreserveMemory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        this.wPreserveMemory.addListener(13, event -> {
            boolean selection = this.wPreserveMemory.getSelection();
            this.wSortedList.setEnabled(selection);
            this.wIntegerPair.setEnabled(selection);
        });
        Label wlReturn = new Label((Composite)this.shell, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ReturnFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 4;
        int upInsRows = this.input.getValue() != null ? this.input.getValue().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.FieldReturn", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Default", (String[])new String[0]), 1, false);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment(100, 0);
        fdReturn.bottom = new FormAttachment((Control)wlPreserveMemory, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        this.getData();
        this.setComboBoxes();
        this.setComboBoxesLookup();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    HashMap<String, Integer> prevFields = new HashMap<String, Integer>();
                    for (int i = 0; i < row.size(); ++i) {
                        prevFields.put(row.getValueMeta(i).getName(), i);
                    }
                    HashMap<String, Integer> fields = new HashMap<String, Integer>();
                    fields.putAll(prevFields);
                    Set keySet = fields.keySet();
                    ArrayList entries = new ArrayList(keySet);
                    String[] fieldNames = entries.toArray(new String[entries.size()]);
                    Const.sortStrings((String[])fieldNames);
                    this.ciKey[0].setComboValues(fieldNames);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
    }

    protected void setComboBoxesLookup() {
        Runnable fieldLoader = () -> {
            TransformMeta lookupTransformMeta = this.pipelineMeta.findTransform(this.wTransform.getText());
            if (lookupTransformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getTransformFields(this.variables, lookupTransformMeta);
                    HashMap<String, Integer> lookupFields = new HashMap<String, Integer>();
                    for (int i = 0; i < row.size(); ++i) {
                        lookupFields.put(row.getValueMeta(i).getName(), i);
                    }
                    HashMap<String, Integer> fields = new HashMap<String, Integer>();
                    fields.putAll(lookupFields);
                    Set keySet = fields.keySet();
                    ArrayList entries = new ArrayList(keySet);
                    String[] fieldNames = entries.toArray(new String[entries.size()]);
                    Const.sortStrings((String[])fieldNames);
                    this.ciReturn[0].setComboValues(fieldNames);
                    this.ciKey[1].setComboValues(fieldNames);
                }
                catch (HopException e) {
                    this.logError("It was not possible to retrieve the list of fields for transform [" + this.wTransform.getText() + "]!");
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getKeystream() != null) {
            for (i = 0; i < this.input.getKeystream().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getKeystream()[i] != null) {
                    item.setText(1, this.input.getKeystream()[i]);
                }
                if (this.input.getKeylookup()[i] == null) continue;
                item.setText(2, this.input.getKeylookup()[i]);
            }
        }
        if (this.input.getValue() != null) {
            for (i = 0; i < this.input.getValue().length; ++i) {
                item = this.wReturn.table.getItem(i);
                if (this.input.getValue()[i] != null) {
                    item.setText(1, this.input.getValue()[i]);
                }
                if (this.input.getValueName()[i] != null && !this.input.getValueName()[i].equals(this.input.getValue()[i])) {
                    item.setText(2, this.input.getValueName()[i]);
                }
                if (this.input.getValueDefault()[i] != null) {
                    item.setText(3, this.input.getValueDefault()[i]);
                }
                item.setText(4, ValueMetaFactory.getValueMetaName((int)this.input.getValueDefaultType()[i]));
            }
        }
        IStream infoStream = (IStream)this.input.getTransformIOMeta().getInfoStreams().get(0);
        this.wTransform.setText(Const.NVL((String)infoStream.getTransformName(), (String)""));
        boolean isPreserveMemory = this.input.isMemoryPreservationActive();
        this.wPreserveMemory.setSelection(isPreserveMemory);
        if (isPreserveMemory) {
            this.wSortedList.setEnabled(true);
            this.wIntegerPair.setEnabled(true);
        }
        this.wSortedList.setSelection(this.input.isUsingSortedList());
        this.wIntegerPair.setSelection(this.input.isUsingIntegerPair());
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrkeys = this.wKey.nrNonEmpty();
        int nrvalues = this.wReturn.nrNonEmpty();
        this.input.allocate(nrkeys, nrvalues);
        this.input.setMemoryPreservationActive(this.wPreserveMemory.getSelection());
        this.input.setUsingSortedList(this.wSortedList.getSelection());
        this.input.setUsingIntegerPair(this.wIntegerPair.getSelection());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.FoundKeys", (String[])new String[]{"" + nrkeys}));
        }
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            this.input.getKeystream()[i] = item.getText(1);
            this.input.getKeylookup()[i] = item.getText(2);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.FoundFields", (String[])new String[]{"" + nrvalues}));
        }
        for (i = 0; i < nrvalues; ++i) {
            item = this.wReturn.getNonEmpty(i);
            this.input.getValue()[i] = item.getText(1);
            this.input.getValueName()[i] = item.getText(2);
            if (this.input.getValueName()[i] == null || this.input.getValueName()[i].length() == 0) {
                this.input.getValueName()[i] = this.input.getValue()[i];
            }
            this.input.getValueDefault()[i] = item.getText(3);
            this.input.getValueDefaultType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(4));
        }
        IStream infoStream = (IStream)this.input.getTransformIOMeta().getInfoStreams().get(0);
        infoStream.setTransformMeta(this.pipelineMeta.findTransform(this.wTransform.getText()));
        if (infoStream.getTransformMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            if (Utils.isEmpty((CharSequence)this.wTransform.getText())) {
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.NotTransformSpecified.DialogMessage", (String[])new String[]{this.wTransform.getText()}));
            } else {
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformCanNotFound.DialogMessage", (String[])new String[]{this.wTransform.getText()}));
            }
            mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformCanNotFound.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (this.pipelineMeta.findTransform(this.wTransform.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PleaseSelectATransformToReadFrom.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PleaseSelectATransformToReadFrom.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            } else {
                String transformFrom = this.wTransform.getText();
                if (!Utils.isEmpty((CharSequence)transformFrom)) {
                    r = this.pipelineMeta.getTransformFields(this.variables, transformFrom);
                    if (r != null) {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)2, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformNameRequired.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformNameRequired.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getlookup() {
        try {
            String transformFrom = this.wTransform.getText();
            if (!Utils.isEmpty((CharSequence)transformFrom)) {
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, transformFrom);
                if (r != null && !r.isEmpty()) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1}, (int[])new int[]{4}, (int)-1, (int)-1, null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformNameRequired.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.TransformNameRequired.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

