/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.transforms.mapping.MappingIODefinition;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;

public class RowDataInputMapper {
    private final RowProducer rowProducer;
    private final MappingIODefinition inputDefinition;
    private boolean first = true;
    private IRowMeta renamedRowMeta;

    public RowDataInputMapper(MappingIODefinition inputDefinition, RowProducer rowProducer) {
        this.inputDefinition = inputDefinition;
        this.rowProducer = rowProducer;
    }

    public boolean putRow(IRowMeta rowMeta, Object[] row) {
        if (this.first) {
            this.first = false;
            this.renamedRowMeta = rowMeta.clone();
            for (MappingValueRename valueRename : this.inputDefinition.getValueRenames()) {
                IValueMeta valueMeta = this.renamedRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(valueRename.getTargetValueName());
            }
        }
        return this.rowProducer.putRow(this.renamedRowMeta, row, false);
    }

    public void finished() {
        this.rowProducer.finished();
    }
}

