/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestDatabaseReplacement;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.PipelineUnitTestTweak;
import org.apache.hop.testing.util.DataSetConst;

public class PipelineMetaModifier {
    private final IVariables variables;
    private final PipelineMeta pipelineMeta;
    private final PipelineUnitTest unitTest;

    public PipelineMetaModifier(IVariables variables, PipelineMeta pipelineMeta, PipelineUnitTest unitTest) {
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.unitTest = unitTest;
    }

    public PipelineMeta getTestPipeline(ILogChannel log, IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        ByteArrayInputStream stream;
        try {
            stream = new ByteArrayInputStream(this.pipelineMeta.getXml(variables).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new HopException("Encoding error", (Throwable)e);
        }
        PipelineMeta copyPipelineMeta = new PipelineMeta((InputStream)stream, metadataProvider, variables);
        copyPipelineMeta.setMetadataProvider(this.pipelineMeta.getMetadataProvider());
        for (PipelineUnitTestDatabaseReplacement dbReplacement : this.unitTest.getDatabaseReplacements()) {
            String sourceDatabaseName = variables.resolve(dbReplacement.getOriginalDatabaseName());
            String replacementDatabaseName = variables.resolve(dbReplacement.getReplacementDatabaseName());
            DatabaseMeta sourceDatabaseMeta = copyPipelineMeta.findDatabase(sourceDatabaseName);
            DatabaseMeta replacementDatabaseMeta = copyPipelineMeta.findDatabase(replacementDatabaseName);
            if (sourceDatabaseMeta == null) {
                throw new HopException("Unable to find source database connection '" + sourceDatabaseName + "', can not be replaced");
            }
            if (replacementDatabaseMeta == null) {
                throw new HopException("Unable to find replacement database connection '" + replacementDatabaseName + "', can not be used to replace");
            }
            if (log.isDetailed()) {
                log.logDetailed("Replaced database connection '" + sourceDatabaseName + "' with connection '" + replacementDatabaseName + "'");
            }
            sourceDatabaseMeta.replaceMeta(replacementDatabaseMeta);
        }
        List transforms = this.pipelineMeta.getTransforms();
        for (TransformMeta transform : transforms) {
            TransformMeta transformMeta = copyPipelineMeta.findTransform(transform.getName());
            PipelineUnitTestSetLocation inputLocation = this.unitTest.findInputLocation(transformMeta.getName());
            PipelineUnitTestSetLocation goldenLocation = this.unitTest.findGoldenLocation(transformMeta.getName());
            PipelineUnitTestTweak transformTweak = this.unitTest.findTweak(transformMeta.getName());
            if (inputLocation != null) {
                this.handleInputDataSet(log, inputLocation, this.unitTest, this.pipelineMeta, transformMeta, metadataProvider);
            }
            if (goldenLocation != null) {
                this.handleGoldenDataSet(log, goldenLocation, transformMeta, metadataProvider);
            }
            if (transformTweak == null || transformTweak.getTweak() == null) continue;
            switch (transformTweak.getTweak()) {
                case NONE: {
                    break;
                }
                case REMOVE_TRANSFORM: {
                    this.handleTweakRemoveTransform(log, copyPipelineMeta, transformMeta);
                    break;
                }
                case BYPASS_TRANSFORM: {
                    this.handleTweakBypassTransform(log, transformMeta);
                    break;
                }
            }
        }
        return copyPipelineMeta;
    }

    private void handleInputDataSet(ILogChannel log, PipelineUnitTestSetLocation inputLocation, PipelineUnitTest unitTest, PipelineMeta pipelineMeta, TransformMeta transformMeta, IHopMetadataProvider metadataProvider) throws HopException {
        DataSet dataSet;
        String inputSetName = inputLocation.getDataSetName();
        if (log.isDetailed()) {
            log.logDetailed("Replacing transform '" + transformMeta.getName() + "' with an Injector for dataset '" + inputSetName + "'");
        }
        try {
            dataSet = (DataSet)metadataProvider.getSerializer(DataSet.class).load(inputSetName);
        }
        catch (HopException e) {
            throw new HopException("Unable to load data set '" + inputSetName + "'");
        }
        IRowMeta transformFields = DataSetConst.getTransformOutputFields(dataSet, inputLocation);
        if (log.isDetailed()) {
            log.logDetailed("Input Data Set '" + inputSetName + "' Injector fields : '" + transformFields.toString());
        }
        InjectorMeta injectorMeta = new InjectorMeta();
        for (IValueMeta valueMeta : transformFields.getValueMetaList()) {
            injectorMeta.getInjectorFields().add(new InjectorField(valueMeta.getName(), valueMeta.getTypeDesc(), Integer.toString(valueMeta.getLength()), Integer.toString(valueMeta.getPrecision())));
        }
        transformMeta.setTransform((ITransformMeta)injectorMeta);
        transformMeta.setTransformPluginId(PluginRegistry.getInstance().getPluginId(TransformPluginType.class, (Object)injectorMeta));
    }

    private void handleGoldenDataSet(ILogChannel log, PipelineUnitTestSetLocation goldenSetName, TransformMeta transformMeta, IHopMetadataProvider metadataProvider) {
        if (log.isDetailed()) {
            log.logDetailed("Replacing transform '" + transformMeta.getName() + "' with an Dummy for golden dataset '" + String.valueOf(goldenSetName) + "'");
        }
        this.replaceTransformWithDummy(log, transformMeta);
    }

    private void replaceTransformWithDummy(ILogChannel log, TransformMeta transformMeta) {
        DummyMeta dummyTransformMeta = new DummyMeta();
        transformMeta.setTransform((ITransformMeta)dummyTransformMeta);
        transformMeta.setTransformPluginId(PluginRegistry.getInstance().getPluginId(TransformPluginType.class, (Object)dummyTransformMeta));
    }

    private void handleTweakBypassTransform(ILogChannel log, TransformMeta transformMeta) {
        if (log.isDetailed()) {
            log.logDetailed("Replacing transform '" + transformMeta.getName() + "' with an Dummy for Bypass transform tweak");
        }
        this.replaceTransformWithDummy(log, transformMeta);
    }

    private void handleTweakRemoveTransform(ILogChannel log, PipelineMeta copyPipelineMeta, TransformMeta transformMeta) {
        if (log.isDetailed()) {
            log.logDetailed("Removing transform '" + transformMeta.getName() + "' for Remove transform tweak");
        }
        List prevTransforms = copyPipelineMeta.findPreviousTransforms(transformMeta);
        for (Object prevTransform : prevTransforms) {
            PipelineHopMeta hop = copyPipelineMeta.findPipelineHop((TransformMeta)prevTransform, transformMeta);
            if (hop == null) continue;
            int hopIndex = copyPipelineMeta.indexOfPipelineHop(hop);
            copyPipelineMeta.removePipelineHop(hopIndex);
        }
        List nextTransforms = copyPipelineMeta.findNextTransforms(transformMeta);
        for (TransformMeta nextTransform : nextTransforms) {
            PipelineHopMeta hop = copyPipelineMeta.findPipelineHop(transformMeta, nextTransform);
            if (hop == null) continue;
            int hopIndex = copyPipelineMeta.indexOfPipelineHop(hop);
            copyPipelineMeta.removePipelineHop(hopIndex);
        }
        int idx = copyPipelineMeta.indexOfTransform(transformMeta);
        if (idx >= 0) {
            copyPipelineMeta.removeTransform(idx);
        }
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public PipelineUnitTest getUnitTest() {
        return this.unitTest;
    }
}

