/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ReplicatedBlockStats {
    private final long lowRedundancyBlocks;
    private final long corruptBlocks;
    private final long missingBlocks;
    private final long missingReplicationOneBlocks;
    private final long bytesInFutureBlocks;
    private final long pendingDeletionBlocks;
    private final Long highestPriorityLowRedundancyBlocks;

    public ReplicatedBlockStats(long lowRedundancyBlocks, long corruptBlocks, long missingBlocks, long missingReplicationOneBlocks, long bytesInFutureBlocks, long pendingDeletionBlocks) {
        this(lowRedundancyBlocks, corruptBlocks, missingBlocks, missingReplicationOneBlocks, bytesInFutureBlocks, pendingDeletionBlocks, null);
    }

    public ReplicatedBlockStats(long lowRedundancyBlocks, long corruptBlocks, long missingBlocks, long missingReplicationOneBlocks, long bytesInFutureBlocks, long pendingDeletionBlocks, Long highestPriorityLowRedundancyBlocks) {
        this.lowRedundancyBlocks = lowRedundancyBlocks;
        this.corruptBlocks = corruptBlocks;
        this.missingBlocks = missingBlocks;
        this.missingReplicationOneBlocks = missingReplicationOneBlocks;
        this.bytesInFutureBlocks = bytesInFutureBlocks;
        this.pendingDeletionBlocks = pendingDeletionBlocks;
        this.highestPriorityLowRedundancyBlocks = highestPriorityLowRedundancyBlocks;
    }

    public long getLowRedundancyBlocks() {
        return this.lowRedundancyBlocks;
    }

    public long getCorruptBlocks() {
        return this.corruptBlocks;
    }

    public long getMissingReplicaBlocks() {
        return this.missingBlocks;
    }

    public long getMissingReplicationOneBlocks() {
        return this.missingReplicationOneBlocks;
    }

    public long getBytesInFutureBlocks() {
        return this.bytesInFutureBlocks;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocks;
    }

    public boolean hasHighestPriorityLowRedundancyBlocks() {
        return this.getHighestPriorityLowRedundancyBlocks() != null;
    }

    public Long getHighestPriorityLowRedundancyBlocks() {
        return this.highestPriorityLowRedundancyBlocks;
    }

    public String toString() {
        StringBuilder statsBuilder = new StringBuilder();
        statsBuilder.append("ReplicatedBlockStats=[").append("LowRedundancyBlocks=").append(this.getLowRedundancyBlocks()).append(", CorruptBlocks=").append(this.getCorruptBlocks()).append(", MissingReplicaBlocks=").append(this.getMissingReplicaBlocks()).append(", MissingReplicationOneBlocks=").append(this.getMissingReplicationOneBlocks()).append(", BytesInFutureBlocks=").append(this.getBytesInFutureBlocks()).append(", PendingDeletionBlocks=").append(this.getPendingDeletionBlocks());
        if (this.hasHighestPriorityLowRedundancyBlocks()) {
            statsBuilder.append(", HighestPriorityLowRedundancyBlocks=").append(this.getHighestPriorityLowRedundancyBlocks());
        }
        statsBuilder.append("]");
        return statsBuilder.toString();
    }

    public static ReplicatedBlockStats merge(Collection<ReplicatedBlockStats> stats) {
        long lowRedundancyBlocks = 0L;
        long corruptBlocks = 0L;
        long missingBlocks = 0L;
        long missingReplicationOneBlocks = 0L;
        long bytesInFutureBlocks = 0L;
        long pendingDeletionBlocks = 0L;
        long highestPriorityLowRedundancyBlocks = 0L;
        boolean hasHighestPriorityLowRedundancyBlocks = false;
        for (ReplicatedBlockStats stat : stats) {
            lowRedundancyBlocks += stat.getLowRedundancyBlocks();
            corruptBlocks += stat.getCorruptBlocks();
            missingBlocks += stat.getMissingReplicaBlocks();
            missingReplicationOneBlocks += stat.getMissingReplicationOneBlocks();
            bytesInFutureBlocks += stat.getBytesInFutureBlocks();
            pendingDeletionBlocks += stat.getPendingDeletionBlocks();
            if (!stat.hasHighestPriorityLowRedundancyBlocks()) continue;
            hasHighestPriorityLowRedundancyBlocks = true;
            highestPriorityLowRedundancyBlocks += stat.getHighestPriorityLowRedundancyBlocks().longValue();
        }
        if (hasHighestPriorityLowRedundancyBlocks) {
            return new ReplicatedBlockStats(lowRedundancyBlocks, corruptBlocks, missingBlocks, missingReplicationOneBlocks, bytesInFutureBlocks, pendingDeletionBlocks, highestPriorityLowRedundancyBlocks);
        }
        return new ReplicatedBlockStats(lowRedundancyBlocks, corruptBlocks, missingBlocks, missingReplicationOneBlocks, bytesInFutureBlocks, pendingDeletionBlocks);
    }
}

