/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.DataTruncation;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.error.MessageUtils;

public abstract class Sqlca {
    private static final int HIGH_ORDER_ROW_COUNT = 0;
    private static final int LOW_ORDER_ROW_COUNT = 1;
    private static final int LOW_ORDER_UPDATE_COUNT = 2;
    private static final int HIGH_ORDER_UPDATE_COUNT = 3;
    public static final int SQL_ERR_LENGTH = 6;
    private transient ClientConnection connection_;
    SqlException exceptionThrownOnStoredProcInvocation_;
    boolean messageTextRetrievedContainsTokensOnly_ = true;
    protected int sqlCode_;
    private String sqlErrmc_;
    private String[] sqlErrmcMessages_;
    private String[] sqlStates_;
    private String sqlErrp_;
    protected int[] sqlErrd_;
    private String sqlWarn_;
    protected String sqlState_;
    protected byte[] sqlErrmcBytes_;
    protected byte[] sqlErrpBytes_;
    protected byte[] sqlWarnBytes_;
    private boolean containsSqlcax_ = true;
    private long rowsetRowCount_;
    private boolean returnTokensOnlyInMessageText_ = false;
    private final transient Agent agent_;
    private String[] cachedMessages;
    private static final String elevenBlanks = "           ";

    protected Sqlca(ClientConnection clientConnection) {
        this.connection_ = clientConnection;
        this.agent_ = this.connection_ != null ? this.connection_.agent_ : null;
    }

    void returnTokensOnlyInMessageText(boolean bl) {
        this.returnTokensOnlyInMessageText_ = bl;
    }

    synchronized int numberOfMessages() {
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ != null) {
            return this.sqlErrmcMessages_.length;
        }
        return 1;
    }

    public synchronized int getSqlCode() {
        return this.sqlCode_;
    }

    public synchronized int getErrorCode() {
        if (this.sqlCode_ >= 0) {
            return this.sqlCode_;
        }
        int n = -(this.sqlCode_ + 1);
        if (n == 20000 && this.connection_ != null && this.connection_.autoCommit_) {
            n = 30000;
        }
        return n;
    }

    public synchronized String getSqlErrmc() {
        int n;
        if (this.sqlErrmc_ != null) {
            return this.sqlErrmc_;
        }
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ == null) {
            return null;
        }
        if (this.sqlErrmcMessages_.length == 0) {
            this.sqlErrmc_ = "";
            return this.sqlErrmc_;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.sqlErrmcMessages_.length - 1; ++n) {
            stringBuffer.append(this.sqlErrmcMessages_[n]);
            stringBuffer.append(MessageUtils.SQLERRMC_MESSAGE_DELIMITER);
            stringBuffer.append(this.sqlStates_[n + 1]);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.sqlErrmcMessages_[n]);
        this.sqlErrmc_ = stringBuffer.toString();
        return this.sqlErrmc_;
    }

    private void initSqlErrmcMessages() {
        if (this.sqlErrmcMessages_ == null || this.sqlStates_ == null) {
            this.processSqlErrmcTokens(this.sqlErrmcBytes_);
        }
    }

    public synchronized String getSqlErrp() {
        if (this.sqlErrp_ != null) {
            return this.sqlErrp_;
        }
        if (this.sqlErrpBytes_ == null) {
            return null;
        }
        this.sqlErrp_ = this.bytes2String(this.sqlErrpBytes_, 0, this.sqlErrpBytes_.length);
        return this.sqlErrp_;
    }

    private int[] getSqlErrd() {
        if (this.sqlErrd_ != null) {
            return this.sqlErrd_;
        }
        this.sqlErrd_ = new int[6];
        return this.sqlErrd_;
    }

    String formatSqlErrd() {
        return Utils.getStringFromInts(this.getSqlErrd());
    }

    public synchronized String getSqlWarn() {
        if (this.sqlWarn_ == null) {
            this.sqlWarn_ = this.sqlWarnBytes_ != null ? this.bytes2String(this.sqlWarnBytes_, 0, this.sqlWarnBytes_.length) : elevenBlanks;
        }
        return this.sqlWarn_;
    }

    public synchronized String getSqlState() {
        return this.sqlState_;
    }

    synchronized String getSqlState(int n) {
        this.initSqlErrmcMessages();
        if (this.sqlStates_ != null) {
            return this.sqlStates_[n];
        }
        return this.getSqlState();
    }

    public Object[] getArgs(int n) {
        if (this.sqlErrmcMessages_ != null) {
            return MessageUtils.getArgs((String)this.getSqlState(n), (String)this.sqlErrmcMessages_[n]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMessage(int n) throws SqlException {
        if (this.cachedMessages != null && this.cachedMessages[n] != null) {
            return this.cachedMessages[n];
        }
        if (this.connection_ == null || this.connection_.isClosedX() || this.returnTokensOnlyInMessageText_) {
            return this.getUnformattedMessage(n);
        }
        ClientCallableStatement clientCallableStatement = null;
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            clientCallableStatement = this.connection_.prepareMessageProc("call SYSIBM.SQLCAMESSAGE(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            clientCallableStatement.isAutoCommittableStatement_ = false;
            String string3 = null;
            String string4 = null;
            if (this.sqlErrmcMessages_ != null) {
                string3 = this.sqlErrmcMessages_[n];
                string4 = this.sqlStates_[n];
            }
            clientCallableStatement.setIntX(1, n == 0 ? this.getSqlCode() : 0);
            clientCallableStatement.setShortX(2, (short)(string3 == null ? 0 : string3.length()));
            clientCallableStatement.setStringX(3, string3);
            clientCallableStatement.setStringX(4, this.getSqlErrp());
            clientCallableStatement.setIntX(5, this.getSqlErrd()[0]);
            clientCallableStatement.setIntX(6, this.getSqlErrd()[1]);
            clientCallableStatement.setIntX(7, this.getSqlErrd()[2]);
            clientCallableStatement.setIntX(8, this.getSqlErrd()[3]);
            clientCallableStatement.setIntX(9, this.getSqlErrd()[4]);
            clientCallableStatement.setIntX(10, this.getSqlErrd()[5]);
            clientCallableStatement.setStringX(11, this.getSqlWarn());
            clientCallableStatement.setStringX(12, string4);
            clientCallableStatement.setStringX(13, null);
            clientCallableStatement.setStringX(14, Locale.getDefault().toString());
            clientCallableStatement.registerOutParameterX(14, 12);
            clientCallableStatement.registerOutParameterX(15, -1);
            clientCallableStatement.registerOutParameterX(16, 4);
            clientCallableStatement.executeX();
            if (clientCallableStatement.getIntX(16) == 0) {
                this.messageTextRetrievedContainsTokensOnly_ = false;
                String string5 = clientCallableStatement.getStringX(15);
                if (this.cachedMessages == null) {
                    this.cachedMessages = new String[this.numberOfMessages()];
                }
                this.cachedMessages[n] = string5;
                String string2 = string5;
                return string2;
            }
            String string = this.getUnformattedMessage(n);
            return string;
            finally {
                if (clientCallableStatement != null) {
                    try {
                        clientCallableStatement.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
            }
        }
    }

    synchronized String getJDBCMessage(int n) {
        if (this.connection_ != null && this.connection_.retrieveMessageText_) {
            try {
                return this.getMessage(n);
            }
            catch (SqlException sqlException) {
                this.exceptionThrownOnStoredProcInvocation_ = sqlException;
                this.chainDeferredExceptionsToAgentOrAsConnectionWarnings(sqlException);
                return this.getUnformattedMessage(n);
            }
        }
        return this.getUnformattedMessage(n);
    }

    private String getUnformattedMessage(int n) {
        String string;
        String string2;
        int n2;
        if (n == 0) {
            n2 = this.getErrorCode();
            string2 = this.getSqlState();
            string = this.getSqlErrmc();
        } else {
            n2 = 0;
            string2 = this.sqlStates_[n];
            string = this.sqlErrmcMessages_[n];
        }
        return "DERBY SQL error: ERRORCODE: " + n2 + ", SQLSTATE: " + string2 + ", SQLERRMC: " + string;
    }

    private void chainDeferredExceptionsToAgentOrAsConnectionWarnings(SqlException sqlException) {
        SqlException sqlException2 = sqlException;
        while (sqlException2 != null) {
            SqlWarning sqlWarning;
            SqlException sqlException3 = sqlException2.getNextException();
            if ((sqlException2 = sqlException2.copyAsUnchainedSQLException(this.agent_.logWriter_)).getErrorCode() == -440) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"), new Object[0]);
                sqlWarning.setNextException(sqlException2.getSQLException());
                this.connection_.accumulate440WarningForMessageProcFailure(sqlWarning);
            } else if (sqlException2.getErrorCode() == -444) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"), new Object[0]);
                sqlWarning.setNextException(sqlException2.getSQLException());
                this.connection_.accumulate444WarningForMessageProcFailure(sqlWarning);
            } else {
                this.agent_.accumulateDeferredException(sqlException2);
            }
            sqlException2 = sqlException3;
        }
    }

    DataTruncation getDataTruncation() {
        String[] stringArray = this.getSqlErrmc().split(MessageUtils.SQLERRMC_TOKEN_DELIMITER);
        return new DataTruncation(Integer.parseInt(stringArray[0]), Boolean.valueOf(stringArray[1]), Boolean.valueOf(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
    }

    private void processSqlErrmcTokens(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        if (n == 0) {
            this.sqlErrmcMessages_ = new String[0];
            this.sqlStates_ = this.sqlErrmcMessages_;
            return;
        }
        String string = this.bytes2String(byArray, 0, n);
        String[] stringArray = string.split("\\u0014{3}");
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = this.getSqlState();
        for (int i = 1; i < stringArray.length; ++i) {
            int n2 = stringArray[i].indexOf(":");
            stringArray2[i] = stringArray[i].substring(0, n2);
            stringArray[i] = stringArray[i].substring(n2 + 1);
        }
        this.sqlStates_ = stringArray2;
        this.sqlErrmcMessages_ = stringArray;
    }

    protected String bytes2String(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Typdef.UTF8ENCODING);
    }

    public long getUpdateCount() {
        if (this.sqlErrd_ == null) {
            return 0L;
        }
        long l = this.getSqlErrd()[2];
        l &= 0xFFFFFFFFL;
        return l |= (long)this.getSqlErrd()[3] << 32;
    }

    public long getRowCount() throws DisconnectException {
        return ((long)this.getSqlErrd()[0] << 32) + (long)this.getSqlErrd()[1];
    }

    public void setContainsSqlcax(boolean bl) {
        this.containsSqlcax_ = bl;
    }

    public boolean containsSqlcax() {
        return this.containsSqlcax_;
    }

    public void resetRowsetSqlca(ClientConnection clientConnection, int n, String string) {
        this.connection_ = clientConnection;
        this.sqlCode_ = n;
        this.sqlState_ = string;
        this.sqlErrpBytes_ = null;
    }

    public void setRowsetRowCount(long l) {
        this.rowsetRowCount_ = l;
    }

    public long getRowsetRowCount() {
        return this.rowsetRowCount_;
    }
}

