/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import com.ibm.as400.micro.ResourceBundleLoader_m;
import com.ibm.as400.micro.Service;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class MEServer
implements Runnable {
    private static final String ME_CONNECTION_ACCEPTED_ = ResourceBundleLoader_m.getText("ME_CONNECTION_ACCEPTED");
    private Socket socket_;
    private MicroDataInputStream input_;
    private MicroDataOutputStream output_;
    private AS400 system_;
    private CommandCall cc_;
    private Connection connection_;
    private Service service_;
    private static final int DATASTREAM_LEVEL = 0;
    private static PrintStream verbose_ = System.out;
    private static boolean verboseState_ = false;
    private static final Hashtable registeredDocuments_ = new Hashtable();
    private static int port_;
    private static int threadIndex_;
    private static final Vector expectedOptions_;
    private static final Hashtable shortcuts_;
    private int nextTransactionID_ = 0;
    private Hashtable cachedJDBCTransactions_ = new Hashtable();

    private MEServer(Socket socket) throws IOException {
        this.socket_ = socket;
        this.input_ = new MicroDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
        this.output_ = new MicroDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
    }

    private int cacheTransaction(ResultSet resultSet) {
        Integer n = new Integer(this.nextTransactionID_++);
        this.cachedJDBCTransactions_.put(n, resultSet);
        return n;
    }

    static char[] byteArrayToCharArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
        }
        return cArray;
    }

    private void close() {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                try {
                                    if (this.connection_ != null) {
                                        this.connection_.close();
                                    }
                                }
                                catch (Exception exception) {
                                    if (!Trace.isTraceErrorOn()) break block19;
                                    Trace.log(2, "Error closing MEServer SQL Connection.", (Throwable)exception);
                                }
                            }
                            try {
                                if (this.system_ != null) {
                                    this.system_.disconnectAllServices();
                                    this.system_ = null;
                                }
                            }
                            catch (Exception exception) {
                                if (!Trace.isTraceErrorOn()) break block20;
                                Trace.log(2, "Error disconnecting all services on MEServer.", (Throwable)exception);
                            }
                        }
                        this.system_ = null;
                        try {
                            if (this.input_ != null) {
                                this.input_.in_.close();
                                this.input_ = null;
                            }
                        }
                        catch (Exception exception) {
                            if (!Trace.isTraceErrorOn()) break block21;
                            Trace.log(2, "Error closing MEServer input stream.", (Throwable)exception);
                        }
                    }
                    try {
                        if (this.output_ != null) {
                            this.output_.out_.close();
                            this.output_ = null;
                        }
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceErrorOn()) break block22;
                        Trace.log(2, "Error closing MEServer output stream.", (Throwable)exception);
                    }
                }
                try {
                    if (this.socket_ != null) {
                        this.socket_.close();
                        this.socket_ = null;
                        if (verboseState_) {
                            verbose_.println(ResourceBundleLoader_m.getText("ME_CONNECTION_CLOSED", Thread.currentThread().getName()));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isTraceErrorOn()) break block23;
                    Trace.log(2, "Error closing MEServer socket.", (Throwable)exception);
                }
            }
            try {
                Enumeration enumeration = this.cachedJDBCTransactions_.keys();
                while (enumeration.hasMoreElements()) {
                    ((AS400JDBCResultSet)this.cachedJDBCTransactions_.get(enumeration)).close();
                    this.cachedJDBCTransactions_.remove(enumeration);
                }
            }
            catch (Exception exception) {
                if (!Trace.isTraceErrorOn()) break block24;
                Trace.log(2, "Error closing SQL Result Set.", (Throwable)exception);
            }
        }
    }

    private static byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2 = byArray3.length;
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray2[n % byArray2.length] ^ byArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray4[n] - byArray[n % byArray.length]);
        }
        return byArray4;
    }

    private void doCommandCall() throws ErrorCompletingRequestException, InterruptedException, IOException {
        String string = this.input_.readUTF();
        if (this.cc_ == null) {
            this.cc_ = new CommandCall(this.system_);
        }
        boolean bl = false;
        try {
            bl = this.cc_.run(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "PropertyVetoException on run(command)", (Throwable)propertyVetoException);
            }
        }
        catch (Exception exception) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(exception);
            return;
        }
        int n = 0;
        AS400Message[] aS400MessageArray = this.cc_.getMessageList();
        if (!bl) {
            n = aS400MessageArray.length;
        }
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of messages returned from ToolboxME CommandCall: " + n);
        }
        this.output_.writeInt(n);
        this.output_.flush();
        for (int i = 0; i < n; ++i) {
            this.output_.writeUTF(aS400MessageArray[i].getID() + ": " + aS400MessageArray[i].getText());
            if (!Trace.isTraceOn()) continue;
            Trace.log(1, aS400MessageArray[i].getText());
        }
        this.output_.flush();
    }

    private void doDataQueueRead() throws IOException, InterruptedException {
        String string = this.input_.readUTF();
        int n = this.input_.readInt();
        DataQueue dataQueue = new DataQueue(this.system_, string);
        DataQueueEntry dataQueueEntry = null;
        try {
            dataQueueEntry = dataQueue.read();
            this.output_.writeInt(4664);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(aS400SecurityException);
            return;
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(errorCompletingRequestException);
            return;
        }
        catch (IOException iOException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(iOException);
            return;
        }
        catch (IllegalObjectTypeException illegalObjectTypeException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(illegalObjectTypeException);
            return;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(objectDoesNotExistException);
            return;
        }
        if (n == 4393) {
            this.output_.writeUTF(dataQueueEntry == null ? "" : dataQueueEntry.getString());
        } else if (n == 4392) {
            if (dataQueueEntry == null) {
                this.output_.writeInt(0);
            } else {
                byte[] byArray = dataQueueEntry.getData();
                this.output_.writeInt(byArray.length);
                this.output_.writeBytes(byArray);
            }
        }
        this.output_.flush();
    }

    private void doDataQueueWrite() throws IOException, InterruptedException {
        String string = this.input_.readUTF();
        int n = this.input_.readInt();
        DataQueue dataQueue = new DataQueue(this.system_, string);
        try {
            if (n == 4392) {
                int n2 = this.input_.readInt();
                byte[] byArray = new byte[n2];
                this.input_.readBytes(byArray);
                dataQueue.write(byArray);
            } else if (n == 4393) {
                String string2 = this.input_.readUTF();
                dataQueue.write(string2);
            }
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(errorCompletingRequestException);
            return;
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(extendedIllegalArgumentException);
            return;
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(aS400SecurityException);
            return;
        }
        catch (IOException iOException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(iOException);
            return;
        }
        catch (IllegalObjectTypeException illegalObjectTypeException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(illegalObjectTypeException);
            return;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(objectDoesNotExistException);
            return;
        }
        this.output_.writeInt(4664);
        this.output_.flush();
    }

    private void doProgramCall() throws IOException, ErrorCompletingRequestException, InterruptedException {
        int n;
        String string = this.input_.readUTF();
        String string2 = this.input_.readUTF();
        int n2 = this.input_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of PCML input Parms:" + n2);
        }
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.input_.readUTF();
            stringArray2[n] = this.input_.readUTF();
            if (!Trace.isTraceOn()) continue;
            Trace.log(6, "ToolboxME PCML input Parm[" + n + "] " + stringArray[n] + ": " + stringArray2[n]);
        }
        n = this.input_.readInt();
        String[] stringArray3 = new String[n];
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of PCML output Parms:" + n);
        }
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = this.input_.readUTF();
        }
        ProgramCallDocument programCallDocument = this.loadDocument(string);
        if (programCallDocument == null) {
            return;
        }
        this.output_.writeInt(4663);
        this.output_.flush();
        boolean bl = false;
        try {
            int n3;
            programCallDocument.setSystem(this.system_);
            for (int i = 0; i < n2; ++i) {
                programCallDocument.setStringValue(stringArray[i], stringArray2[i], 0);
            }
            bl = programCallDocument.callProgram(string2);
            String[] stringArray4 = null;
            if (bl) {
                stringArray4 = new String[n];
                for (n3 = 0; n3 < n; ++n3) {
                    stringArray4[n3] = programCallDocument.getStringValue(stringArray3[n3], 0);
                    if (!Trace.isTraceOn()) continue;
                    Trace.log(6, "ToolboxME PCML ouput Parm[" + n3 + "] " + stringArray3[n3] + ": " + stringArray4[n3]);
                }
            }
            this.output_.writeBoolean(bl);
            this.output_.flush();
            if (!bl) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList(string2);
                if (Trace.isTraceOn()) {
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        Trace.log(2, aS400MessageArray[i].getText());
                    }
                }
                this.output_.writeInt(38);
                this.output_.writeUTF(aS400MessageArray[0].getID() + ": " + aS400MessageArray[0].getText());
                this.output_.flush();
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    this.output_.writeUTF(stringArray4[n3] == null ? "" : stringArray4[n3]);
                    this.output_.flush();
                }
            }
        }
        catch (PcmlException pcmlException) {
            Exception exception = pcmlException.getException();
            if (exception != null) {
                verbose_.println(exception.getMessage());
                this.output_.writeBoolean(false);
                this.sendException(exception);
            } else {
                if (verboseState_) {
                    verbose_.println(pcmlException.getLocalizedMessage());
                }
                this.sendException(pcmlException);
            }
            return;
        }
    }

    private static ProgramCallDocument getPCMLDocument(String string) throws PcmlException {
        ProgramCallDocument programCallDocument = (ProgramCallDocument)registeredDocuments_.get(string);
        if (programCallDocument != null) {
            if (verboseState_) {
                verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_CACHE", string));
            }
            return programCallDocument;
        }
        if (verboseState_) {
            verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_LOADING", string));
        }
        programCallDocument = new ProgramCallDocument();
        programCallDocument.setDocument(string);
        registeredDocuments_.put(string, programCallDocument);
        return programCallDocument;
    }

    private ProgramCallDocument loadDocument(String string) {
        try {
            return MEServer.getPCMLDocument(string);
        }
        catch (PcmlException pcmlException) {
            block20: {
                verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                if (Trace.isTraceOn()) {
                    Trace.log(2, pcmlException);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        this.output_.writeInt(37);
                        this.output_.writeUTF(pcmlException.getLocalizedMessage());
                        this.output_.flush();
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceErrorOn()) break block20;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)exception);
                    }
                }
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            block21: {
                if (string == null) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                }
                if (Trace.isTraceOn()) {
                    Trace.log(2, noClassDefFoundError);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        this.output_.writeInt(37);
                        this.output_.writeUTF(noClassDefFoundError.getClass().getName() + ": " + noClassDefFoundError.getMessage());
                        this.output_.flush();
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceErrorOn()) break block21;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)exception);
                    }
                }
            }
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            block22: {
                if (string == null) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                }
                if (Trace.isTraceOn()) {
                    Trace.log(2, missingResourceException);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        if (string.length() == 0) {
                            this.output_.writeInt(16);
                        } else {
                            this.output_.writeInt(37);
                        }
                        this.output_.writeUTF(missingResourceException.getClass().getName() + ": " + missingResourceException.getMessage());
                        this.output_.flush();
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceErrorOn()) break block22;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)exception);
                    }
                }
            }
            return null;
        }
    }

    public static void main(String[] stringArray) {
        block7: {
            try {
                if (MEServer.parseArgs(stringArray)) {
                    ServerSocket serverSocket = new ServerSocket(port_);
                    verbose_.println(ResourceBundleLoader_m.getText("ME_SERVER_STARTED"));
                    if (verboseState_) {
                        verbose_.println(ResourceBundleLoader_m.getText("ME_SERVER_LISTENING", ResourceBundleLoader_m.getText("ME_SERVER_CONTAINER"), Integer.toString(port_)));
                    }
                    while (true) {
                        Socket socket = serverSocket.accept();
                        MEServer mEServer = new MEServer(socket);
                        Thread thread = new Thread((Runnable)mEServer, "ToolboxMEThread-" + threadIndex_++);
                        thread.setDaemon(true);
                        thread.start();
                        if (!verboseState_) continue;
                        verbose_.println(ResourceBundleLoader_m.substitute(ME_CONNECTION_ACCEPTED_, new Object[]{"MEServer", socket.getInetAddress().toString(), thread.getName()}));
                    }
                }
                MEServer.usage(System.out);
            }
            catch (BindException bindException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Error opening ToolboxME server socket.", (Throwable)bindException);
                }
                verbose_.println(ResourceBundleLoader_m.getText("ME_ALREADY_LISTENING", Integer.toString(port_)));
            }
            catch (IOException iOException) {
                if (!Trace.isTraceErrorOn()) break block7;
                Trace.log(2, "Error opening ToolboxME server socket.", (Throwable)iOException);
            }
        }
    }

    static byte[] nextBytes(Random random, int n) {
        byte[] byArray = new byte[n];
        long l = random.nextLong();
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (n2 > 7) {
                l = random.nextLong();
                n2 = 0;
            }
            byArray[i] = (byte)(0xFFL & l >> 8 * n2++);
        }
        return byArray;
    }

    private static boolean parseArgs(String[] stringArray) {
        Enumeration<Object> enumeration;
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, expectedOptions_, shortcuts_);
        if (commandLineArguments.getOptionValue("-help") != null) {
            return false;
        }
        String string = commandLineArguments.getOptionValue("-verbose");
        if (string != null) {
            if (string.length() == 0 || string.equalsIgnoreCase("true")) {
                verboseState_ = true;
            } else if (string.equalsIgnoreCase("false")) {
                verboseState_ = false;
            } else {
                throw new IllegalArgumentException(ResourceBundleLoader_m.getText("ME_OPTION_VALUE_NOT_VALID", new String[]{"verbose", string}));
            }
        }
        if ((string = commandLineArguments.getOptionValue("-pcml")) != null) {
            enumeration = new StringTokenizer(string, ";");
            while (((StringTokenizer)enumeration).hasMoreTokens()) {
                try {
                    MEServer.getPCMLDocument(((StringTokenizer)enumeration).nextToken());
                }
                catch (PcmlException pcmlException) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                    if (verboseState_) {
                        verbose_.println(pcmlException.getMessage());
                    }
                    if (!Trace.isTraceOn()) continue;
                    Trace.log(2, pcmlException);
                }
            }
        }
        if ((string = commandLineArguments.getOptionValue("-port")) != null) {
            if (string.length() > 0) {
                port_ = Integer.parseInt(string);
            }
        } else {
            port_ = 3470;
        }
        enumeration = commandLineArguments.getExtraOptions();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            verbose_.println(ResourceBundleLoader_m.getText("ME_OPTION_NOT_VALID", string2));
        }
        return true;
    }

    private static String resolve(byte[] byArray) {
        byte[] byArray2 = new byte[18];
        System.arraycopy(byArray, 0, byArray2, 0, 18);
        byte[] byArray3 = new byte[14];
        System.arraycopy(byArray, 18, byArray3, 0, 14);
        byte[] byArray4 = new byte[byArray.length - 32];
        System.arraycopy(byArray, 32, byArray4, 0, byArray.length - 32);
        return new String(MEServer.byteArrayToCharArray(MEServer.decode(byArray2, byArray3, byArray4)));
    }

    public void run() {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block14: while (!bl2 & !bl) {
                int n = this.input_.readInt();
                if (Trace.isTraceOn()) {
                    Trace.log(6, "ME Datastream Request: " + Integer.toHexString(n));
                }
                switch (n) {
                    case 4386: {
                        this.signon();
                        continue block14;
                    }
                    case 4387: {
                        this.doCommandCall();
                        continue block14;
                    }
                    case 4388: {
                        this.doProgramCall();
                        continue block14;
                    }
                    case 4390: {
                        this.doDataQueueRead();
                        continue block14;
                    }
                    case 4391: {
                        this.doDataQueueWrite();
                        continue block14;
                    }
                    case 4688: 
                    case 4689: 
                    case 4690: 
                    case 4691: 
                    case 4692: 
                    case 4693: 
                    case 4694: 
                    case 4695: 
                    case 4696: 
                    case 4705: 
                    case 4706: 
                    case 4707: 
                    case 4708: 
                    case 4721: 
                    case 4737: 
                    case 4738: 
                    case 4739: 
                    case 4740: 
                    case 4741: 
                    case 4742: 
                    case 4743: 
                    case 4744: 
                    case 4745: 
                    case 4752: 
                    case 4753: 
                    case 4754: 
                    case 4755: 
                    case 4756: 
                    case 4757: 
                    case 4758: {
                        if (this.service_ == null) {
                            this.service_ = new JdbcMeService();
                        }
                        this.service_.setDataStreams(this.input_, this.output_);
                        try {
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Trying service com.ibm.as400.micro.JdbcMeService for Function id " + Integer.toHexString(n));
                            }
                            if (this.service_.acceptsRequest(n)) continue block14;
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Servicing function id " + Integer.toHexString(n));
                            }
                            this.service_.handleRequest(n);
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Service complete");
                            }
                            this.output_.flush();
                        }
                        catch (EOFException eOFException) {
                            if (!Trace.isTraceOn()) continue block14;
                            Trace.log(2, "EOF: Client disconnected", (Throwable)eOFException);
                        }
                        catch (IOException iOException) {
                            if (!Trace.isTraceOn()) continue block14;
                            Trace.log(2, "IOException detected - finally block handles cleanup.", (Throwable)iOException);
                        }
                        continue block14;
                    }
                    case 4389: {
                        if (Trace.isTraceOn()) {
                            Trace.log(6, "ToolboxME disconnect received.");
                        }
                        this.close();
                        bl2 = true;
                        continue block14;
                    }
                }
                this.output_.writeInt(4665);
                this.output_.writeInt(4672);
                this.output_.writeUTF("ToolboxME Request not supported: " + Integer.toHexString(n));
                this.output_.flush();
            }
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception);
            }
            this.stop(exception.getMessage());
        }
        this.close();
    }

    private void signon() throws IOException {
        int n = this.input_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, "Micro client datastream level: " + n);
        }
        byte[] byArray = new byte[18];
        this.input_.readBytes(byArray);
        this.output_.writeInt(0);
        byte[] byArray2 = MEServer.nextBytes(new Random(), 14);
        this.output_.writeBytes(byArray2);
        this.output_.flush();
        String string = this.input_.readUTF();
        String string2 = this.input_.readUTF();
        int n2 = this.input_.readInt();
        byte[] byArray3 = new byte[n2];
        this.input_.readBytes(byArray3);
        if (this.system_ != null) {
            this.system_.disconnectAllServices();
        }
        boolean bl = false;
        try {
            this.system_ = new AS400(string, string2, MEServer.resolve(MEServer.decode(byArray, byArray2, byArray3)));
            this.system_.setLocale(Locale.US);
            bl = this.system_.validateSignon();
        }
        catch (Exception exception) {
            this.system_ = null;
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(exception);
            return;
        }
        int n3 = 4660;
        if (!bl) {
            this.system_ = null;
            n3 = 4661;
        }
        this.output_.writeInt(n3);
        this.output_.flush();
    }

    private final void stop(String string) {
        block5: {
            block4: {
                try {
                    this.output_.writeInt(4665);
                    this.output_.writeUTF(string);
                }
                catch (Exception exception) {
                    if (!Trace.isTraceErrorOn()) break block4;
                    Trace.log(2, "Error returning exception, during stop, to ME client.", (Throwable)exception);
                }
            }
            try {
                this.output_.flush();
            }
            catch (Exception exception) {
                if (!Trace.isTraceErrorOn()) break block5;
                Trace.log(2, "Error flushing output stream during MEServer stop.", (Throwable)exception);
            }
        }
        this.close();
    }

    private void sendException(Exception exception) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "ME Exception Occurred: \n", (Throwable)exception);
        }
        if (exception instanceof AS400SecurityException) {
            int n = ((AS400SecurityException)exception).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + n);
            }
            switch (n) {
                case 6: {
                    this.output_.writeInt(2);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                case 7: {
                    this.output_.writeInt(3);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                case 8: {
                    this.output_.writeInt(4);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                case 30: {
                    this.output_.writeInt(5);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                case 31: {
                    this.output_.writeInt(6);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                case 32: {
                    this.output_.writeInt(7);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
                default: {
                    this.output_.writeInt(1);
                    this.output_.writeUTF(exception.getMessage());
                    break;
                }
            }
        } else if (exception instanceof PcmlException) {
            this.output_.writeBoolean(false);
            this.output_.writeInt(40);
            this.output_.writeUTF(exception.getLocalizedMessage());
        } else if (exception instanceof ObjectDoesNotExistException) {
            this.output_.writeInt(9);
            this.output_.writeUTF(exception.getMessage());
        } else if (exception instanceof ExtendedIllegalArgumentException) {
            int n = ((ExtendedIllegalArgumentException)exception).getReturnCode();
            if (n == 1) {
                this.output_.writeInt(18);
            } else {
                this.output_.writeInt(16);
            }
            this.output_.writeUTF(exception.getMessage());
        } else if (exception instanceof ExtendedIllegalStateException) {
            this.output_.writeInt(17);
            this.output_.writeUTF(exception.getMessage());
        } else if (exception instanceof ErrorCompletingRequestException) {
            int n = ((ErrorCompletingRequestException)exception).getReturnCode();
            if (n == 9) {
                this.output_.writeInt(18);
            } else {
                this.output_.writeInt(53);
            }
            this.output_.writeUTF(exception.getMessage());
        } else if (exception instanceof ConnectionDroppedException) {
            int n = ((ConnectionDroppedException)exception).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + n);
            }
            if (n == 2) {
                this.output_.writeInt(32);
                this.output_.writeUTF(exception.getMessage());
            } else {
                this.output_.writeInt(53);
                this.output_.writeUTF(exception.getMessage());
            }
        } else if (exception instanceof IllegalObjectTypeException) {
            this.output_.writeInt(39);
            this.output_.writeUTF(exception.getMessage());
        } else if (exception instanceof ServerStartupException) {
            int n = ((ServerStartupException)exception).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + n);
            }
            if (n == 3) {
                this.output_.writeInt(33);
                this.output_.writeUTF(exception.getMessage());
            } else {
                this.output_.writeInt(53);
                this.output_.writeUTF(exception.getMessage());
            }
        } else if (exception instanceof UnknownHostException) {
            this.output_.writeInt(34);
            this.output_.writeUTF(exception.toString());
        } else if (exception instanceof IOException) {
            this.output_.writeInt(53);
            this.output_.writeUTF(exception.toString());
        } else {
            this.output_.writeInt(53);
            this.output_.writeUTF(exception.getMessage());
        }
        this.output_.flush();
    }

    static void usage(PrintStream printStream) {
        String string = ResourceBundleLoader_m.getText("ME_SERVER_USAGE");
        String string2 = ResourceBundleLoader_m.getText("ME_SERVER_OPTIONSLC");
        String string3 = ResourceBundleLoader_m.getText("ME_SERVER_OPTIONSUC");
        String string4 = ResourceBundleLoader_m.getText("ME_SERVER_SHORTCUTS");
        printStream.println(string + ":");
        printStream.println();
        printStream.println("  com.ibm.as400.access.MEServer [ " + string2 + " ]");
        printStream.println();
        printStream.println(string3 + ":");
        printStream.println();
        printStream.println("  -pcml     [pcml doc]");
        printStream.println("  -port     port");
        printStream.println("  -verbose  [true | false]");
        printStream.println("  -help");
        printStream.println();
        printStream.println(string4 + ":");
        printStream.println("  -v   [true | false]");
        printStream.println("  -pc  pcml doc1 [;pcml doc2;...]");
        printStream.println("  -po  port");
        printStream.println("  -h");
        printStream.println("  -?");
    }

    static {
        threadIndex_ = 0;
        expectedOptions_ = new Vector();
        shortcuts_ = new Hashtable();
        expectedOptions_.addElement("-port");
        expectedOptions_.addElement("-pcml");
        expectedOptions_.addElement("-verbose");
        expectedOptions_.addElement("-help");
        shortcuts_.put("-po", "-port");
        shortcuts_.put("-pc", "-pcml");
        shortcuts_.put("-v", "-verbose");
        shortcuts_.put("-h", "-help");
        shortcuts_.put("-?", "-help");
    }
}

