/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ResourceLoader {
    private ResourceBundle m_bundle = null;

    ResourceLoader() {
    }

    public void setResourceName(String string) {
        if (this.m_bundle == null) {
            try {
                this.m_bundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                Trace.log(2, missingResourceException);
            }
        }
    }

    public String getString(String string) {
        if (this.m_bundle != null) {
            try {
                return this.m_bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                Trace.log(2, missingResourceException);
                try {
                    return MessageFormat.format(this.m_bundle.getString("MISSING_KEY"), string);
                }
                catch (Exception exception) {
                    return "RESOURCE BUNDLE ERROR.";
                }
            }
        }
        return "RESOURCE BUNDLE ERROR.";
    }

    public String getStringWithNoSubstitute(String string) {
        if (this.m_bundle != null) {
            try {
                return this.m_bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return null;
    }
}

