/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.FTP;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

class FTPThread
implements Runnable {
    static long threadCount = 0L;
    static Object threadCountLock = new Object();
    private FTP ftp_;
    private int port_;
    private Socket socket_;
    private boolean running_ = false;
    private final Object runLock_ = new Object();
    private InetAddress localAddress_;

    FTPThread(FTP fTP) {
        this.ftp_ = fTP;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress_ = inetAddress;
        if (Trace.traceOn_) {
            Trace.log(1, "FTP thread's local address set to: " + this.localAddress_.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilStarted() {
        try {
            while (!this.running_) {
                Object object = this.runLock_;
                synchronized (object) {
                    if (!this.running_) {
                        this.runLock_.wait();
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            Trace.log(2, "Error while waiting for FTP thread to start.", (Throwable)exception);
        }
    }

    public int getLocalPort() {
        return this.port_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket() {
        Object object;
        if (this.socket_ == null) {
            try {
                object = this;
                synchronized (object) {
                    if (this.socket_ == null) {
                        this.wait(60000L);
                    }
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Error while getting socket from FTP thread.", (Throwable)exception);
                return null;
            }
        }
        object = this.socket_;
        this.socket_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "FTP thread returned previously accepted socket.");
            if (object == null) {
                Trace.log(1, "FTPThread.getSocket() is returning null.");
            }
        }
        return object;
    }

    public void issuePortCommand() throws IOException {
        String string = this.localAddress_.getHostAddress();
        String string2 = this.ftp_.issueCommand("EPRT |" + (string.indexOf(58) == -1 ? "1" : "2") + "|" + string + "|" + this.port_ + "|");
        if (string2.startsWith("200")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer("PORT ");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(",");
        }
        stringBuffer.append(this.port_ / 256);
        stringBuffer.append(",");
        stringBuffer.append(this.port_ % 256);
        string2 = this.ftp_.issueCommand(stringBuffer.toString());
        if (!string2.startsWith("200")) {
            Trace.log(2, "Unexpected response to " + stringBuffer + ": " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = threadCountLock;
        synchronized (object) {
            try {
                Thread.currentThread().setName("FTPThread-" + threadCount);
                ++threadCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        try {
            try {
                if (this.ftp_.isReuseSocket()) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread will reuse socket if multiple transfers.");
                    }
                    object = new ServerSocket(0, 50, this.localAddress_);
                    this.port_ = ((ServerSocket)object).getLocalPort();
                    while (true) {
                        Object object2;
                        if (Trace.traceOn_) {
                            Trace.log(1, "FTP thread waiting for new active mode socket.");
                        }
                        if (!this.running_) {
                            this.running_ = true;
                            object2 = this.runLock_;
                            synchronized (object2) {
                                this.runLock_.notifyAll();
                            }
                        }
                        this.socket_ = ((ServerSocket)object).accept();
                        if (Trace.traceOn_) {
                            Trace.log(1, "FTP thread accepted active mode socket: " + this.socket_);
                        }
                        object2 = this;
                        synchronized (object2) {
                            this.notifyAll();
                        }
                    }
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "FTP thread create new socket if multiple transfers.");
                }
                while (true) {
                    Object object3;
                    if (object == null) {
                        object = new ServerSocket(0, 1, this.localAddress_);
                        this.port_ = ((ServerSocket)object).getLocalPort();
                    }
                    if (!this.running_) {
                        this.running_ = true;
                        object3 = this.runLock_;
                        synchronized (object3) {
                            this.runLock_.notifyAll();
                        }
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread waiting for new active mode socket.");
                    }
                    this.socket_ = ((ServerSocket)object).accept();
                    if (Trace.traceOn_) {
                        Trace.log(1, "FTP thread accepted active mode socket: " + this.socket_);
                    }
                    object3 = this;
                    synchronized (object3) {
                        this.notifyAll();
                    }
                    ((ServerSocket)object).close();
                    object = null;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable22;
                Trace.log(2, "Exception in FTP thread.", throwable);
                Object var9_11 = null;
                if (this.socket_ != null) {
                    try {
                        this.socket_.close();
                    }
                    catch (Throwable throwable22) {
                        Trace.log(2, throwable22);
                    }
                }
                if (object != null) {
                    try {
                        ((ServerSocket)object).close();
                    }
                    catch (Throwable throwable22) {
                        Trace.log(2, throwable22);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable32;
            Object var9_12 = null;
            if (this.socket_ != null) {
                try {
                    this.socket_.close();
                }
                catch (Throwable throwable32) {
                    Trace.log(2, throwable32);
                }
            }
            if (object != null) {
                try {
                    ((ServerSocket)object).close();
                }
                catch (Throwable throwable32) {
                    Trace.log(2, throwable32);
                }
            }
            throw throwable;
        }
    }
}

