/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.schema.compaction;

import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.SizeTieredCompactionStrategy;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface TimeWindowCompactionStrategy<SelfT extends TimeWindowCompactionStrategy<SelfT>>
extends CompactionStrategy<SelfT>,
SizeTieredCompactionStrategy<SelfT> {
    @NonNull
    @CheckReturnValue
    default public SelfT withCompactionWindow(long size, @NonNull CompactionWindowUnit unit) {
        return (SelfT)((TimeWindowCompactionStrategy)((TimeWindowCompactionStrategy)this.withOption("compaction_window_size", size)).withOption("compaction_window_unit", unit.toString()));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withUnsafeAggressiveSSTableExpiration(boolean enabled) {
        return (SelfT)((TimeWindowCompactionStrategy)this.withOption("unsafe_aggressive_sstable_expiration", enabled));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withTimestampResolution(@NonNull TimestampResolution timestampResolution) {
        return (SelfT)((TimeWindowCompactionStrategy)this.withOption("timestamp_resolution", timestampResolution.toString()));
    }

    public static enum TimestampResolution {
        MICROSECONDS,
        MILLISECONDS;

    }

    public static enum CompactionWindowUnit {
        MINUTES,
        HOURS,
        DAYS;

    }
}

