/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import org.apache.hop.core.SwtUniversalImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;

public class SwtUniversalImageBitmap
extends SwtUniversalImage {
    private final Image bitmap;
    private final double zoomFactor;

    public SwtUniversalImageBitmap(Image bitmap, double zoomFactor) {
        this.bitmap = bitmap;
        this.zoomFactor = zoomFactor;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (!this.bitmap.isDisposed()) {
            this.bitmap.dispose();
        }
    }

    @Override
    protected Image renderSimple(Device device) {
        return this.bitmap;
    }

    @Override
    protected Image renderSimple(Device device, int width, int height) {
        return this.renderRotated(device, width, height, 0.0);
    }

    @Override
    protected Image renderRotated(Device device, int width, int height, double angleRadians) {
        Image result = new Image(device, width * 2, height * 2);
        GC gc = new GC((Drawable)result);
        int bw = this.bitmap.getBounds().width;
        int bh = this.bitmap.getBounds().height;
        Transform affineTransform = new Transform(device);
        affineTransform.translate((float)width, (float)height);
        affineTransform.rotate((float)Math.toDegrees(angleRadians));
        affineTransform.scale((float)this.zoomFactor * (float)width / (float)bw, (float)this.zoomFactor * (float)height / (float)bh);
        gc.setTransform(affineTransform);
        gc.drawImage(this.bitmap, 0, 0, bw, bh, -bw / 2, -bh / 2, bw, bh);
        gc.dispose();
        return result;
    }
}

