/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.variables;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.HopURLClassLoader;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.Variable;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.core.xml.XmlHandler;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VariableRegistry {
    private static VariableRegistry instance;
    private final Map<VariableScope, List<DescribedVariable>> variableScopes = new EnumMap<VariableScope, List<DescribedVariable>>(VariableScope.class);
    private final List<String> deprecatedNames;

    private VariableRegistry() {
        this.variableScopes.put(VariableScope.SYSTEM, new ArrayList());
        this.variableScopes.put(VariableScope.APPLICATION, new ArrayList());
        this.variableScopes.put(VariableScope.ENGINE, new ArrayList());
        this.deprecatedNames = new ArrayList<String>();
    }

    public static VariableRegistry getInstance() {
        return instance;
    }

    public static void init() throws HopException {
        instance = new VariableRegistry();
        try {
            Index index;
            JarCache cache = JarCache.getInstance();
            for (File jarFile : cache.getNativeJars()) {
                index = cache.getIndex(jarFile);
                for (AnnotationInstance info : index.getAnnotations(Variable.class)) {
                    VariableRegistry.register(jarFile, info.target().asField());
                }
            }
            for (File jarFile : cache.getPluginJars()) {
                index = cache.getIndex(jarFile);
                for (AnnotationInstance info : index.getAnnotations(Variable.class)) {
                    VariableRegistry.register(jarFile, info.target().asField());
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logDetailed("Unable to find variable definitions", e);
        }
    }

    protected static void register(File jarFile, FieldInfo fieldInfo) throws ClassNotFoundException, SecurityException, NoSuchFieldException, MalformedURLException {
        Deprecated deprecated;
        URLClassLoader urlClassLoader = VariableRegistry.createUrlClassLoader(jarFile.toURI().toURL(), FieldInfo.class.getClassLoader());
        Class<?> clazz = urlClassLoader.loadClass(fieldInfo.declaringClass().name().toString());
        Field field = clazz.getDeclaredField(fieldInfo.name());
        Variable variable = field.getAnnotation(Variable.class);
        String description = TranslateUtil.translate(variable.description(), clazz);
        DescribedVariable describedVariable = new DescribedVariable(field.getName(), variable.value(), description);
        List<DescribedVariable> list = VariableRegistry.instance.variableScopes.get((Object)variable.scope());
        if (list != null) {
            list.add(describedVariable);
        }
        if ((deprecated = field.getAnnotation(Deprecated.class)) != null) {
            VariableRegistry.instance.deprecatedNames.add(field.getName());
        }
    }

    protected static URLClassLoader createUrlClassLoader(URL jarFileUrl, ClassLoader classLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String dependenciesFileName;
            File dependenciesFile;
            JarCache jarCache = JarCache.getInstance();
            String parentFolderName = new File(URLDecoder.decode(jarFileUrl.getFile(), "UTF-8")).getParent();
            File libFolder = new File(parentFolderName + Const.FILE_SEPARATOR + "lib");
            if (libFolder.exists()) {
                for (File libFile : jarCache.findJarFiles(libFolder)) {
                    urls.add(libFile.toURI().toURL());
                }
            }
            if ((dependenciesFile = new File(dependenciesFileName = parentFolderName + Const.FILE_SEPARATOR + "dependencies.xml")).exists()) {
                Document document = XmlHandler.loadXmlFile(dependenciesFile);
                Node dependenciesNode = XmlHandler.getSubNode(document, "dependencies");
                List<Node> folderNodes = XmlHandler.getNodes(dependenciesNode, "folder");
                for (Node folderNode : folderNodes) {
                    String relativeFolderName = XmlHandler.getNodeValue(folderNode);
                    String dependenciesFolderName = parentFolderName + Const.FILE_SEPARATOR + relativeFolderName;
                    File dependenciesFolder = new File(dependenciesFolderName);
                    if (!dependenciesFolder.exists()) continue;
                    for (File libFile : jarCache.findJarFiles(dependenciesFolder)) {
                        urls.add(libFile.toURI().toURL());
                    }
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Unexpected error searching for variable in file '" + String.valueOf(jarFileUrl) + "'", e);
        }
        urls.add(jarFileUrl);
        return new HopURLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
    }

    public DescribedVariable findDescribedVariable(String name) {
        for (VariableScope scope : VariableScope.values()) {
            for (DescribedVariable variable : this.variableScopes.get((Object)scope)) {
                if (!variable.getName().equals(name)) continue;
                return variable;
            }
        }
        return null;
    }

    public Set<String> getVariableNames() {
        return this.getVariableNames(VariableScope.values());
    }

    public Set<String> getVariableNames(VariableScope ... scopes) {
        TreeSet<String> names = new TreeSet<String>();
        for (VariableScope scope : scopes) {
            for (DescribedVariable variable : this.variableScopes.get((Object)scope)) {
                names.add(variable.getName());
            }
        }
        return names;
    }

    public List<DescribedVariable> getDescribedVariables() {
        return this.getDescribedVariables(VariableScope.values());
    }

    public List<DescribedVariable> getDescribedVariables(VariableScope ... scopes) {
        ArrayList<DescribedVariable> list = new ArrayList<DescribedVariable>();
        for (VariableScope scope : scopes) {
            for (DescribedVariable variable : this.variableScopes.get((Object)scope)) {
                list.add(variable);
            }
        }
        return list;
    }

    public List<String> getDeprecatedVariableNames() {
        return this.deprecatedNames;
    }
}

