/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import ru.yandex.clickhouse.ClickHouseUtil;
import ru.yandex.clickhouse.util.ClickHouseArrayUtil;
import ru.yandex.clickhouse.util.ClickHouseBitmap;

public final class ClickHouseValueFormatter {
    public static final String NULL_MARKER = "\\N";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static ThreadLocal<SimpleDateFormat> dateTimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static String formatBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 4];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 4] = 92;
            hexChars[j * 4 + 1] = 120;
            hexChars[j * 4 + 2] = hexArray[v / 16];
            hexChars[j * 4 + 3] = hexArray[v % 16];
        }
        return new String(hexChars);
    }

    public static String formatInt(int myInt) {
        return Integer.toString(myInt);
    }

    public static String formatDouble(double myDouble) {
        return Double.toString(myDouble);
    }

    public static String formatChar(char myChar) {
        return Character.toString(myChar);
    }

    public static String formatLong(long myLong) {
        return Long.toString(myLong);
    }

    public static String formatFloat(float myFloat) {
        return Float.toString(myFloat);
    }

    public static String formatBigDecimal(BigDecimal myBigDecimal) {
        return myBigDecimal != null ? myBigDecimal.toPlainString() : NULL_MARKER;
    }

    public static String formatShort(short myShort) {
        return Short.toString(myShort);
    }

    public static String formatString(String myString) {
        return ClickHouseUtil.escape(myString);
    }

    public static String formatNull() {
        return NULL_MARKER;
    }

    public static String formatByte(byte myByte) {
        return Byte.toString(myByte);
    }

    public static String formatBoolean(boolean myBoolean) {
        return myBoolean ? "1" : "0";
    }

    public static String formatDate(Date date, TimeZone timeZone) {
        SimpleDateFormat formatter = ClickHouseValueFormatter.getDateFormat();
        formatter.setTimeZone(timeZone);
        return formatter.format(date);
    }

    public static String formatTime(Time time, TimeZone timeZone) {
        return TIME_FORMATTER.format(Instant.ofEpochMilli(time.getTime()).atZone(timeZone.toZoneId()).toLocalTime());
    }

    public static String formatTimestamp(Timestamp time, TimeZone timeZone) {
        SimpleDateFormat formatter = ClickHouseValueFormatter.getDateTimeFormat();
        formatter.setTimeZone(timeZone);
        StringBuilder formatted = new StringBuilder(formatter.format(time));
        if (time != null && time.getNanos() % 1000000 > 0) {
            formatted.append('.').append(time.getNanos());
        }
        return formatted.toString();
    }

    public static String formatUUID(UUID x) {
        return x.toString();
    }

    public static String formatBigInteger(BigInteger x) {
        return x.toString();
    }

    public static String formatLocalDate(LocalDate x) {
        return DATE_FORMATTER.format(x);
    }

    public static String formatLocalDateTime(LocalDateTime x) {
        return DATE_TIME_FORMATTER.format(x);
    }

    public static String formatLocalTime(LocalTime x) {
        return TIME_FORMATTER.format(x);
    }

    public static String formatOffsetTime(OffsetTime x) {
        return DateTimeFormatter.ISO_OFFSET_TIME.format(x);
    }

    public static String formatOffsetDateTime(OffsetDateTime x, TimeZone timeZone) {
        return DATE_TIME_FORMATTER.withZone(timeZone.toZoneId()).format(x);
    }

    public static String formatZonedDateTime(ZonedDateTime x, TimeZone timeZone) {
        return DATE_TIME_FORMATTER.withZone(timeZone.toZoneId()).format(x);
    }

    public static String formatInstant(Instant x, TimeZone timeZone) {
        return DATE_TIME_FORMATTER.withZone(timeZone.toZoneId()).format(x);
    }

    public static String formatBitmap(ClickHouseBitmap bitmap) {
        return bitmap.toBitmapBuildExpression();
    }

    public static String formatMap(Map<?, ?> map, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append(',');
            if (key instanceof String) {
                sb.append('\'').append(ClickHouseValueFormatter.formatString((String)key)).append('\'');
            } else {
                sb.append(ClickHouseValueFormatter.formatObject(key, dateTimeZone, dateTimeTimeZone));
            }
            sb.append(':');
            if (value instanceof String) {
                sb.append('\'').append(ClickHouseValueFormatter.formatString((String)value)).append('\'');
                continue;
            }
            sb.append(ClickHouseValueFormatter.formatObject(value, dateTimeZone, dateTimeTimeZone));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.insert(0, '{').append('}').toString();
    }

    public static String formatObject(Object x, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        if (x == null) {
            return null;
        }
        if (x instanceof Byte) {
            return ClickHouseValueFormatter.formatInt(((Byte)x).intValue());
        }
        if (x instanceof String) {
            return ClickHouseValueFormatter.formatString((String)x);
        }
        if (x instanceof BigDecimal) {
            return ClickHouseValueFormatter.formatBigDecimal((BigDecimal)x);
        }
        if (x instanceof Short) {
            return ClickHouseValueFormatter.formatShort((Short)x);
        }
        if (x instanceof Integer) {
            return ClickHouseValueFormatter.formatInt((Integer)x);
        }
        if (x instanceof Long) {
            return ClickHouseValueFormatter.formatLong((Long)x);
        }
        if (x instanceof Float) {
            return ClickHouseValueFormatter.formatFloat(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return ClickHouseValueFormatter.formatDouble((Double)x);
        }
        if (x instanceof byte[]) {
            return ClickHouseValueFormatter.formatBytes((byte[])x);
        }
        if (x instanceof Date) {
            return ClickHouseValueFormatter.formatDate((Date)x, dateTimeZone);
        }
        if (x instanceof LocalDate) {
            return ClickHouseValueFormatter.formatLocalDate((LocalDate)x);
        }
        if (x instanceof Time) {
            return ClickHouseValueFormatter.formatTime((Time)x, dateTimeTimeZone);
        }
        if (x instanceof LocalTime) {
            return ClickHouseValueFormatter.formatLocalTime((LocalTime)x);
        }
        if (x instanceof OffsetTime) {
            return ClickHouseValueFormatter.formatOffsetTime((OffsetTime)x);
        }
        if (x instanceof Timestamp) {
            return ClickHouseValueFormatter.formatTimestamp((Timestamp)x, dateTimeTimeZone);
        }
        if (x instanceof LocalDateTime) {
            return ClickHouseValueFormatter.formatLocalDateTime((LocalDateTime)x);
        }
        if (x instanceof OffsetDateTime) {
            return ClickHouseValueFormatter.formatOffsetDateTime((OffsetDateTime)x, dateTimeTimeZone);
        }
        if (x instanceof ZonedDateTime) {
            return ClickHouseValueFormatter.formatZonedDateTime((ZonedDateTime)x, dateTimeTimeZone);
        }
        if (x instanceof Boolean) {
            return ClickHouseValueFormatter.formatBoolean((Boolean)x);
        }
        if (x instanceof UUID) {
            return ClickHouseValueFormatter.formatUUID((UUID)x);
        }
        if (x instanceof BigInteger) {
            return ClickHouseValueFormatter.formatBigInteger((BigInteger)x);
        }
        if (x instanceof Collection) {
            return ClickHouseArrayUtil.toString((Collection)x, dateTimeZone, dateTimeTimeZone);
        }
        if (x instanceof ClickHouseBitmap) {
            return ClickHouseValueFormatter.formatBitmap((ClickHouseBitmap)x);
        }
        if (x instanceof Map) {
            return ClickHouseValueFormatter.formatMap((Map)x, dateTimeZone, dateTimeTimeZone);
        }
        if (x.getClass().isArray()) {
            return ClickHouseArrayUtil.arrayToString(x, dateTimeZone, dateTimeTimeZone);
        }
        return String.valueOf(x);
    }

    public static boolean needsQuoting(Object o) {
        return o != null && !(o instanceof Array) && !(o instanceof Boolean) && !(o instanceof Collection) && !(o instanceof Map) && !(o instanceof Number) && !o.getClass().isArray() && !(o instanceof ClickHouseBitmap);
    }

    private static SimpleDateFormat getDateFormat() {
        return dateFormat.get();
    }

    private static SimpleDateFormat getDateTimeFormat() {
        return dateTimeFormat.get();
    }

    private ClickHouseValueFormatter() {
    }
}

