/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.NoOpStepContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SparkSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.SideInputBroadcast;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.CachedSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import scala.collection.Iterator;

class DoFnMapPartitionsFactory<InT, OutT>
implements Serializable {
    private final String stepName;
    private final DoFn<InT, OutT> doFn;
    private final DoFnSchemaInformation doFnSchema;
    private final SerializablePipelineOptions options;
    private final Coder<InT> coder;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final TupleTag<OutT> mainOutput;
    private final List<TupleTag<?>> additionalOutputs;
    private final Map<TupleTag<?>, Coder<?>> outputCoders;
    private final Map<String, PCollectionView<?>> sideInputs;
    private final Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputWindows;
    private final SideInputBroadcast broadcastStateData;

    DoFnMapPartitionsFactory(String stepName, DoFn<InT, OutT> doFn, DoFnSchemaInformation doFnSchema, SerializablePipelineOptions options, PCollection<InT> input, TupleTag<OutT> mainOutput, Map<TupleTag<?>, PCollection<?>> outputs, Map<String, PCollectionView<?>> sideInputs, SideInputBroadcast broadcastStateData) {
        this.stepName = stepName;
        this.doFn = doFn;
        this.doFnSchema = doFnSchema;
        this.options = options;
        this.coder = input.getCoder();
        this.windowingStrategy = input.getWindowingStrategy();
        this.mainOutput = mainOutput;
        this.additionalOutputs = DoFnMapPartitionsFactory.additionalOutputs(outputs, mainOutput);
        this.outputCoders = DoFnMapPartitionsFactory.outputCoders(outputs);
        this.sideInputs = sideInputs;
        this.sideInputWindows = DoFnMapPartitionsFactory.sideInputWindows(sideInputs.values());
        this.broadcastStateData = broadcastStateData;
    }

    <OutputT> ScalaInterop.Fun1<Iterator<WindowedValue<InT>>, Iterator<OutputT>> create(ScalaInterop.Fun2<TupleTag<?>, WindowedValue<?>, OutputT> outputFn) {
        return it -> it.hasNext() ? ScalaInterop.scalaIterator(new DoFnPartitionIt(outputFn, it)) : Iterator.empty();
    }

    private <OutputT> DoFnRunner<InT, OutT> simpleRunner(final ScalaInterop.Fun2<TupleTag<?>, WindowedValue<?>, OutputT> outputFn, final Deque<OutputT> buffer) {
        DoFnRunners.OutputManager outputManager = new DoFnRunners.OutputManager(){

            public <T> void output(TupleTag<T> tag, WindowedValue<T> output) {
                buffer.add(outputFn.apply(tag, output));
            }
        };
        CachedSideInputReader sideInputReader = CachedSideInputReader.of(new SparkSideInputReader(this.sideInputWindows, this.broadcastStateData));
        return DoFnRunners.simpleRunner((PipelineOptions)this.options.get(), this.doFn, (SideInputReader)sideInputReader, (DoFnRunners.OutputManager)outputManager, this.mainOutput, this.additionalOutputs, (StepContext)new NoOpStepContext(), this.coder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchema, this.sideInputs);
    }

    private DoFnRunner<InT, OutT> metricsRunner(DoFnRunner<InT, OutT> runner) {
        return new DoFnRunnerWithMetrics<InT, OutT>(this.stepName, runner, MetricsAccumulator.getInstance());
    }

    private static Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputWindows(Collection<PCollectionView<?>> views) {
        return views.stream().collect(Collectors.toMap(Function.identity(), DoFnMapPartitionsFactory::windowingStrategy));
    }

    private static WindowingStrategy<?, ?> windowingStrategy(PCollectionView<?> view) {
        PCollection pc = view.getPCollection();
        if (pc == null) {
            throw new IllegalStateException("PCollection not available for " + view);
        }
        return pc.getWindowingStrategy();
    }

    private static List<TupleTag<?>> additionalOutputs(Map<TupleTag<?>, PCollection<?>> outputs, TupleTag<?> mainOutput) {
        return outputs.keySet().stream().filter(t -> !t.equals((Object)mainOutput)).collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)(outputs.size() - 1))));
    }

    private static Map<TupleTag<?>, Coder<?>> outputCoders(Map<TupleTag<?>, PCollection<?>> outputs) {
        return outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    private class DoFnPartitionIt<FnInT extends InT, OutputT>
    extends AbstractIterator<OutputT> {
        private final Deque<OutputT> buffer = new ArrayDeque<OutputT>();
        private final DoFnRunner<InT, OutT> doFnRunner;
        private final Iterator<WindowedValue<FnInT>> partitionIt;
        private boolean isBundleFinished;

        DoFnPartitionIt(ScalaInterop.Fun2<TupleTag<?>, WindowedValue<?>, OutputT> outputFn, Iterator<WindowedValue<FnInT>> partitionIt) {
            this.doFnRunner = DoFnMapPartitionsFactory.this.metricsRunner(DoFnMapPartitionsFactory.this.simpleRunner(outputFn, this.buffer));
            this.partitionIt = partitionIt;
            DoFnInvokers.tryInvokeSetupFor((DoFn)DoFnMapPartitionsFactory.this.doFn, (PipelineOptions)DoFnMapPartitionsFactory.this.options.get());
            try {
                this.doFnRunner.startBundle();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)DoFnMapPartitionsFactory.this.doFn).invokeTeardown();
                throw re;
            }
        }

        protected OutputT computeNext() {
            try {
                while (true) {
                    if (!this.buffer.isEmpty()) {
                        return this.buffer.remove();
                    }
                    if (this.partitionIt.hasNext()) {
                        this.doFnRunner.processElement((WindowedValue)this.partitionIt.next());
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                }
                DoFnInvokers.invokerFor((DoFn)DoFnMapPartitionsFactory.this.doFn).invokeTeardown();
                return (OutputT)this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)DoFnMapPartitionsFactory.this.doFn).invokeTeardown();
                throw re;
            }
        }
    }
}

