/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.aggregators;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class NamedAggregators
implements Serializable {
    private final Map<String, State<?, ?, ?>> mNamedAggregators = new TreeMap();

    public <T> T getValue(String name, Class<T> typeClass) {
        State<?, ?, ?> state = this.mNamedAggregators.get(name);
        return state != null ? (T)typeClass.cast(state.render()) : null;
    }

    public Map<String, ?> renderAll() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.mNamedAggregators, State::render));
    }

    public NamedAggregators merge(NamedAggregators other) {
        for (Map.Entry<String, State<?, ?, ?>> e : other.mNamedAggregators.entrySet()) {
            String key = e.getKey();
            State<?, ?, ?> otherValue = e.getValue();
            this.mNamedAggregators.merge(key, otherValue, NamedAggregators::merge);
        }
        return this;
    }

    private static <InputT, InterT, OutputT> State<InputT, InterT, OutputT> merge(State<?, ?, ?> s1, State<?, ?, ?> s2) {
        return s1.merge(s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, State<?, ?, ?>> e : this.mNamedAggregators.entrySet()) {
            sb.append(e.getKey()).append(": ").append(e.getValue().render()).append(" ");
        }
        return sb.toString();
    }

    public static interface State<InputT, InterT, OutputT>
    extends Serializable {
        public void update(InputT var1);

        public State<InputT, InterT, OutputT> merge(State<InputT, InterT, OutputT> var1);

        public InterT current();

        public OutputT render();

        public Combine.CombineFn<InputT, InterT, OutputT> getCombineFn();
    }
}

