/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.drools.core.util.index.TupleList;
import org.kie.internal.security.KiePolicyHelper;

public class MultiAccumulate
extends Accumulate {
    private Accumulator[] accumulators;
    private int arraySize;

    public MultiAccumulate() {
    }

    public MultiAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Accumulator[] accumulators, int arraySize) {
        super(source, requiredDeclarations);
        this.arraySize = arraySize;
        this.accumulators = accumulators;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.arraySize = in.readInt();
        this.accumulators = new Accumulator[in.readInt()];
        for (int i = 0; i < this.accumulators.length; ++i) {
            this.accumulators[i] = (Accumulator)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.arraySize);
        out.writeInt(this.accumulators.length);
        for (Accumulator acc : this.accumulators) {
            if (Accumulator.isCompiledInvoker(acc)) {
                out.writeObject(null);
                continue;
            }
            out.writeObject(acc);
        }
    }

    @Override
    public boolean isMultiFunction() {
        return true;
    }

    @Override
    public Accumulator[] getAccumulators() {
        return this.accumulators;
    }

    public Object[] createFunctionContext() {
        Object[] ctxs = new Object[this.accumulators.length];
        for (int i = 0; i < this.accumulators.length; ++i) {
            ctxs[i] = this.accumulators[i].createContext();
        }
        return ctxs;
    }

    @Override
    public Object init(Object workingMemoryContext, Object accContext, Object funcContext, Tuple leftTuple, WorkingMemory workingMemory) {
        Object[] functionContext = (Object[])funcContext;
        for (int i = 0; i < this.accumulators.length; ++i) {
            functionContext[i] = this.accumulators[i].init(((Object[])workingMemoryContext)[i], functionContext[i], leftTuple, this.requiredDeclarations, workingMemory);
        }
        return funcContext;
    }

    @Override
    public Object accumulate(Object workingMemoryContext, Object context, Tuple match, InternalFactHandle handle, WorkingMemory workingMemory) {
        Object[] values = new Object[this.accumulators.length];
        for (int i = 0; i < this.accumulators.length; ++i) {
            Object[] functionContext = (Object[])((AccumulateNode.AccumulateContextEntry)context).getFunctionContext();
            values[i] = this.accumulators[i].accumulate(((Object[])workingMemoryContext)[i], functionContext[i], match, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
        }
        return values;
    }

    @Override
    public Object accumulate(Object workingMemoryContext, Tuple match, InternalFactHandle childHandle, AccumulateNode.GroupByContext groupByContext, TupleList<AccumulateNode.AccumulateContextEntry> tupleList, WorkingMemory wm) {
        throw new UnsupportedOperationException("This should never be called, it's for LambdaGroupByAccumulate only.");
    }

    @Override
    public boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, RightTuple rightParent, LeftTuple match, WorkingMemory workingMemory) {
        Object[] values = (Object[])match.getContextObject();
        for (int i = 0; i < this.accumulators.length; ++i) {
            Object[] functionContext = (Object[])((AccumulateNode.AccumulateContextEntry)context).getFunctionContext();
            boolean reversed = this.accumulators[i].tryReverse(((Object[])workingMemoryContext)[i], functionContext[i], leftTuple, handle, values[i], this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
            if (reversed) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsReverse() {
        for (Accumulator acc : this.accumulators) {
            if (acc.supportsReverse()) continue;
            return false;
        }
        return true;
    }

    public Object[] getResult(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        Object[] results = new Object[this.arraySize];
        for (int i = 0; i < this.accumulators.length; ++i) {
            Object[] functionContext = (Object[])((AccumulateNode.AccumulateContextEntry)context).getFunctionContext();
            results[i] = this.accumulators[i].getResult(((Object[])workingMemoryContext)[i], functionContext[i], leftTuple, this.requiredDeclarations, workingMemory);
        }
        return results;
    }

    @Override
    public void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        for (Accumulator accumulator : this.accumulators) {
            if (!(accumulator instanceof MvelAccumulator)) continue;
            ((MvelAccumulator)accumulator).replaceDeclaration(declaration, resolved);
        }
    }

    @Override
    public MultiAccumulate clone() {
        RuleConditionElement clonedSource = this.source instanceof GroupElement ? ((GroupElement)this.source).cloneOnlyGroup() : this.source.clone();
        MultiAccumulate clone = new MultiAccumulate(clonedSource, this.requiredDeclarations, this.accumulators, this.arraySize);
        this.registerClone(clone);
        return clone;
    }

    public Object[] createWorkingMemoryContext() {
        Object[] ctx = new Object[this.accumulators.length];
        for (int i = 0; i < this.accumulators.length; ++i) {
            ctx[i] = this.accumulators[i].createWorkingMemoryContext();
        }
        return ctx;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accumulators);
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiAccumulate other = (MultiAccumulate)obj;
        if (!Arrays.equals(this.accumulators, other.accumulators)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        if (this.source == null) {
            return other.source == null;
        }
        return this.source.equals(other.source);
    }

    public final class Wirer
    implements Wireable.Immutable,
    Serializable {
        private static final long serialVersionUID = -9072646735174734614L;
        private transient boolean initialized;
        private final int index;

        public Wirer(int index) {
            this.index = index;
        }

        @Override
        public void wire(Object object) {
            Accumulator accumulator = KiePolicyHelper.isPolicyEnabled() ? new Accumulator.SafeAccumulator((Accumulator)object) : (Accumulator)object;
            ((MultiAccumulate)MultiAccumulate.this).accumulators[this.index] = accumulator;
            for (Accumulate clone : MultiAccumulate.this.cloned) {
                ((MultiAccumulate)((MultiAccumulate)clone)).accumulators[this.index] = accumulator;
            }
            this.initialized = true;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

