/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.base.ClassObjectType;
import org.drools.core.facttemplates.Fact;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FactTemplateTypeConf;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;

public class ObjectTypeConfigurationRegistry
implements Serializable {
    private static final long serialVersionUID = 510L;
    private final Map<Object, ObjectTypeConf> typeConfMap = new ConcurrentHashMap<Object, ObjectTypeConf>();
    private final InternalKnowledgeBase kBase;

    public ObjectTypeConfigurationRegistry(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
    }

    public ObjectTypeConf getObjectTypeConf(Object object) {
        return this.typeConfMap.get(this.getKey(object));
    }

    public ObjectTypeConf getOrCreateObjectTypeConf(EntryPointId entrypoint, Object object) {
        ObjectTypeConf existingConf;
        Object key = this.getKey(object);
        ObjectTypeConf conf = this.typeConfMap.get(key);
        if (conf == null && (existingConf = this.typeConfMap.putIfAbsent(key, conf = this.createObjectTypeConf(entrypoint, key, object))) != null) {
            conf = existingConf;
        }
        return conf;
    }

    private Object getKey(Object object) {
        if (object instanceof Activation) {
            return ClassObjectType.Match_ObjectType.getClassType();
        }
        if (object instanceof Fact) {
            return ((Fact)object).getFactTemplate().getName();
        }
        return object.getClass();
    }

    private ObjectTypeConf createObjectTypeConf(EntryPointId entrypoint, Object key, Object object) {
        return object instanceof Fact ? new FactTemplateTypeConf(entrypoint, ((Fact)object).getFactTemplate(), this.kBase) : new ClassObjectTypeConf(entrypoint, (Class)key, this.kBase);
    }

    public ObjectTypeConf getObjectTypeConfByClass(Class<?> cls) {
        return this.typeConfMap.get(cls);
    }

    public Collection<ObjectTypeConf> values() {
        return this.typeConfMap.values();
    }
}

