/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import com.microsoft.azure.eventhubs.impl.MessageWrapper;
import com.microsoft.azure.eventhubs.impl.PassByRef;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.qpid.proton.message.Message;

final class EventDataUtil {
    static final Set<String> RESERVED_SYSTEM_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("x-opt-offset");
            this.add("x-opt-partition-key");
            this.add("x-opt-sequence-number");
            this.add("x-opt-enqueued-time");
            this.add("x-opt-publisher");
        }
    });

    private EventDataUtil() {
    }

    static LinkedList<EventData> toEventDataCollection(Collection<Message> messages, PassByRef<MessageWrapper> lastMessageRef) {
        if (messages == null) {
            return null;
        }
        LinkedList<EventData> events = new LinkedList<EventData>();
        for (Message message : messages) {
            EventDataImpl eventData = new EventDataImpl(message);
            events.add(eventData);
            if (lastMessageRef == null) continue;
            lastMessageRef.set(new MessageWrapper(message, EventPosition.fromSequenceNumber(eventData.getSystemProperties().getSequenceNumber(), true)));
        }
        return events;
    }

    static Iterable<Message> toAmqpMessages(Iterable<EventData> eventDatas, final String partitionKey) {
        final LinkedList<Message> messages = new LinkedList<Message>();
        eventDatas.forEach(new Consumer<EventData>(){

            @Override
            public void accept(EventData eventData) {
                EventDataImpl eventDataImpl = (EventDataImpl)eventData;
                Message amqpMessage = partitionKey == null ? eventDataImpl.toAmqpMessage() : eventDataImpl.toAmqpMessage(partitionKey);
                messages.add(amqpMessage);
            }
        });
        return messages;
    }

    static Iterable<Message> toAmqpMessages(Iterable<EventData> eventDatas) {
        return EventDataUtil.toAmqpMessages(eventDatas, null);
    }
}

