/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.ImmutablePair;

public class ThroughputEstimator
implements Serializable {
    private static final long serialVersionUID = -3597929310338724800L;
    private Timestamp startTimeOfCurrentWindow;
    private BigDecimal bytesInCurrentWindow;
    private final int numOfSeconds = 60;
    private BigDecimal bytesInQueue;
    private final Queue<ImmutablePair<Timestamp, BigDecimal>> queue = new ArrayDeque<ImmutablePair<Timestamp, BigDecimal>>();

    public ThroughputEstimator() {
        this.startTimeOfCurrentWindow = Timestamp.MIN_VALUE;
        this.bytesInCurrentWindow = BigDecimal.valueOf(0L);
        this.bytesInQueue = BigDecimal.valueOf(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Timestamp timeOfRecords, long bytes) {
        Queue<ImmutablePair<Timestamp, BigDecimal>> queue = this.queue;
        synchronized (queue) {
            BigDecimal bytesNum = BigDecimal.valueOf(bytes);
            if (this.startTimeOfCurrentWindow.equals((Object)Timestamp.MIN_VALUE)) {
                this.bytesInCurrentWindow = bytesNum;
                this.startTimeOfCurrentWindow = timeOfRecords;
                return;
            }
            if (timeOfRecords.getSeconds() < this.startTimeOfCurrentWindow.getSeconds() + 1L) {
                this.bytesInCurrentWindow = this.bytesInCurrentWindow.add(bytesNum);
            } else {
                this.queue.add((ImmutablePair<Timestamp, BigDecimal>)new ImmutablePair((Object)this.startTimeOfCurrentWindow, (Object)this.bytesInCurrentWindow));
                this.bytesInQueue = this.bytesInQueue.add(this.bytesInCurrentWindow);
                this.bytesInCurrentWindow = bytesNum;
                this.startTimeOfCurrentWindow = timeOfRecords;
            }
            this.cleanQueue(this.startTimeOfCurrentWindow);
        }
    }

    public double get() {
        return this.getFrom(Timestamp.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFrom(Timestamp time) {
        Queue<ImmutablePair<Timestamp, BigDecimal>> queue = this.queue;
        synchronized (queue) {
            this.cleanQueue(time);
            if (this.queue.size() == 0) {
                return 0.0;
            }
            return this.bytesInQueue.divide(BigDecimal.valueOf(this.queue.size()), MathContext.DECIMAL128).max(BigDecimal.ZERO).doubleValue();
        }
    }

    private void cleanQueue(Timestamp time) {
        ImmutablePair<Timestamp, BigDecimal> peek;
        while (this.queue.size() > 0 && ((peek = this.queue.peek()) == null || ((Timestamp)peek.getLeft()).getSeconds() < time.getSeconds() - 60L)) {
            ImmutablePair<Timestamp, BigDecimal> pair = this.queue.remove();
            this.bytesInQueue = this.bytesInQueue.subtract((BigDecimal)pair.getRight()).max(BigDecimal.ZERO);
        }
    }
}

