/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Statement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_ReadOperation;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class ReadOperation
implements Serializable {
    public static ReadOperation create() {
        return new AutoValue_ReadOperation.Builder().setPartitionOptions(PartitionOptions.getDefaultInstance()).setKeySet(KeySet.all()).build();
    }

    public abstract @Nullable Statement getQuery();

    public abstract @Nullable String getQueryName();

    public abstract @Nullable String getTable();

    public abstract @Nullable String getIndex();

    public abstract @Nullable List<String> getColumns();

    public abstract @Nullable KeySet getKeySet();

    abstract @Nullable PartitionOptions getPartitionOptions();

    abstract Builder toBuilder();

    public ReadOperation withTable(String table) {
        return this.toBuilder().setTable(table).build();
    }

    public ReadOperation withColumns(String ... columns) {
        return this.withColumns(Arrays.asList(columns));
    }

    public ReadOperation withColumns(List<String> columns) {
        return this.toBuilder().setColumns(columns).build();
    }

    public ReadOperation withQuery(Statement statement) {
        return this.toBuilder().setQuery(statement).build();
    }

    public ReadOperation withQuery(String sql) {
        return this.withQuery(Statement.of((String)sql));
    }

    public ReadOperation withQueryName(String queryName) {
        return this.toBuilder().setQueryName(queryName).build();
    }

    public ReadOperation withKeySet(KeySet keySet) {
        return this.toBuilder().setKeySet(keySet).build();
    }

    public ReadOperation withIndex(String index) {
        return this.toBuilder().setIndex(index).build();
    }

    public ReadOperation withPartitionOptions(PartitionOptions partitionOptions) {
        return this.toBuilder().setPartitionOptions(partitionOptions).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setQuery(Statement var1);

        abstract Builder setQueryName(String var1);

        abstract Builder setTable(String var1);

        abstract Builder setIndex(String var1);

        abstract Builder setColumns(List<String> var1);

        abstract Builder setKeySet(KeySet var1);

        abstract Builder setPartitionOptions(PartitionOptions var1);

        abstract ReadOperation build();
    }
}

