/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.TimestampBound;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;

class CreateTransactionFn
extends DoFn<Object, Transaction> {
    private final SpannerConfig config;
    private final TimestampBound timestampBound;
    private transient SpannerAccessor spannerAccessor;

    CreateTransactionFn(SpannerConfig config, TimestampBound timestampBound) {
        this.config = config;
        this.timestampBound = timestampBound;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        BatchReadOnlyTransaction tx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(this.timestampBound);
        c.output((Object)Transaction.create(tx.getBatchTransactionId()));
    }
}

