/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.cloud.pubsublite.proto.Subscription;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.PTransformMatchers;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedFactoryImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriberImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiterImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRangeTracker;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerServerSubscriberCache;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerSubscriptionPartitionSdf;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriberAssembler;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionLoader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.UnboundedSourceImpl;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeTransform
extends PTransform<PBegin, PCollection<SequencedMessage>> {
    private static final Logger LOG = LoggerFactory.getLogger(SubscribeTransform.class);
    private static final long MEBIBYTE = 0x100000L;
    private static final long SOFT_MEMORY_LIMIT = 0x20000000L;
    private static final long MIN_PER_PARTITION_MEMORY = 0x400000L;
    private static final long MAX_PER_PARTITION_MEMORY = 0x6400000L;
    private static final MemoryLimiter LIMITER = new MemoryLimiterImpl(0x400000L, 0x6400000L, 0x20000000L);
    private final SubscriberOptions options;
    public static final PTransformOverride V1_READ_OVERRIDE = PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(SubscribeTransform.class), (PTransformOverrideFactory)new ReadOverrideFactory());

    public SubscribeTransform(SubscriberOptions options) {
        this.options = options;
    }

    private void checkSubscription(SubscriptionPartition subscriptionPartition) throws ApiException {
        UncheckedApiPreconditions.checkArgument((boolean)subscriptionPartition.subscription().equals(this.options.subscriptionPath()));
    }

    private Subscriber newSubscriber(Partition partition, Offset initialOffset, Consumer<List<SequencedMessage>> consumer) {
        try {
            return new SubscriberAssembler(this.options, partition).getSubscriberFactory(initialOffset).newSubscriber(messages -> consumer.accept(messages.stream().map(message -> message.toProto()).collect(Collectors.toList())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private MemoryBufferedSubscriber newBufferedSubscriber(SubscriptionPartition subscriptionPartition, Offset startOffset) throws ApiException {
        this.checkSubscription(subscriptionPartition);
        return new MemoryBufferedSubscriberImpl(subscriptionPartition.partition(), startOffset, LIMITER, consumer -> this.newSubscriber(subscriptionPartition.partition(), startOffset, (Consumer<List<SequencedMessage>>)consumer));
    }

    private MemoryBufferedSubscriber getCachedSubscriber(SubscriptionPartition subscriptionPartition, Offset startOffset) {
        Supplier<MemoryBufferedSubscriber> getOrCreate = () -> PerServerSubscriberCache.CACHE.get(subscriptionPartition, () -> this.newBufferedSubscriber(subscriptionPartition, startOffset));
        MemoryBufferedSubscriber subscriber;
        Offset fetchOffset;
        while (!startOffset.equals(fetchOffset = (subscriber = getOrCreate.get()).fetchOffset())) {
            LOG.info("Discarding subscriber due to mismatch, this should be rare. {}, start: {} fetch: {}", new Object[]{subscriptionPartition, startOffset, fetchOffset});
            try {
                subscriber.stopAsync().awaitTerminated();
            }
            catch (Exception exception) {
            }
        }
        return subscriber;
    }

    private SubscriptionPartitionProcessor newPartitionProcessor(SubscriptionPartition subscriptionPartition, RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker, DoFn.OutputReceiver<SequencedMessage> receiver) {
        return new SubscriptionPartitionProcessorImpl(tracker, receiver, this.getCachedSubscriber(subscriptionPartition, Offset.of((long)((OffsetByteRange)tracker.currentRestriction()).getRange().getFrom())));
    }

    private TopicBacklogReader newBacklogReader(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getBacklogReader();
    }

    private TrackerWithProgress newRestrictionTracker(TopicBacklogReader backlogReader, OffsetByteRange initial) {
        return new OffsetByteRangeTracker(initial, backlogReader);
    }

    private InitialOffsetReader newInitialOffsetReader(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getInitialOffsetReader();
    }

    private BlockingCommitter newCommitter(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).newCommitter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TopicPath getTopicPath() {
        try (AdminClient admin = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(this.options.subscriptionPath().location().extractRegion()).build());){
            TopicPath topicPath = TopicPath.parse((String)((Subscription)admin.getSubscription(this.options.subscriptionPath()).get()).getTopic());
            return topicPath;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private PCollection<SequencedMessage> expandSdf(PBegin input) {
        PCollection subscriptionPartitions = (PCollection)input.apply((PTransform)new SubscriptionPartitionLoader(this.getTopicPath(), this.options.subscriptionPath()));
        return (PCollection)subscriptionPartitions.apply((PTransform)ParDo.of((DoFn)new PerSubscriptionPartitionSdf(new ManagedFactoryImpl<TopicBacklogReader>(this::newBacklogReader), new ManagedFactoryImpl<BlockingCommitter>(this::newCommitter), (SerializableFunction<SubscriptionPartition, InitialOffsetReader>)((SerializableFunction & Serializable)this::newInitialOffsetReader), (SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress>)((SerializableBiFunction & Serializable)this::newRestrictionTracker), this::newPartitionProcessor)));
    }

    private PCollection<SequencedMessage> expandSource(PBegin input) {
        return (PCollection)input.apply((PTransform)Read.from((UnboundedSource)new UnboundedSourceImpl(this.options, this::newBufferedSubscriber, this::newBacklogReader)));
    }

    public PCollection<SequencedMessage> expand(PBegin input) {
        return this.expandSdf(input);
    }

    private static class ReadOverrideFactory
    implements PTransformOverrideFactory<PBegin, PCollection<SequencedMessage>, SubscribeTransform> {
        private ReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<SequencedMessage>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<SequencedMessage>, SubscribeTransform> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)new SourceTransform((SubscribeTransform)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<SequencedMessage> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static final class SourceTransform
    extends PTransform<PBegin, PCollection<SequencedMessage>> {
        private final SubscribeTransform impl;

        private SourceTransform(SubscribeTransform impl) {
            this.impl = impl;
        }

        public PCollection<SequencedMessage> expand(PBegin input) {
            return this.impl.expandSource(input);
        }
    }
}

