/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;

class SplittingIterable
implements Iterable<ProtoRows> {
    private final Iterable<StorageApiWritePayload> underlying;
    private final long splitSize;
    private final Function<Long, StorageApiDynamicDestinations.DescriptorWrapper> updateSchema;
    private StorageApiDynamicDestinations.DescriptorWrapper currentDescriptor;

    public SplittingIterable(Iterable<StorageApiWritePayload> underlying, long splitSize, StorageApiDynamicDestinations.DescriptorWrapper currentDescriptor, Function<Long, StorageApiDynamicDestinations.DescriptorWrapper> updateSchema) {
        this.underlying = underlying;
        this.splitSize = splitSize;
        this.updateSchema = updateSchema;
        this.currentDescriptor = currentDescriptor;
    }

    @Override
    public Iterator<ProtoRows> iterator() {
        return new Iterator<ProtoRows>(){
            final Iterator<StorageApiWritePayload> underlyingIterator;
            {
                this.underlyingIterator = SplittingIterable.this.underlying.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public ProtoRows next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext()) {
                    StorageApiWritePayload payload = this.underlyingIterator.next();
                    if (payload.getSchemaHash() != ((SplittingIterable)SplittingIterable.this).currentDescriptor.hash) {
                        SplittingIterable.this.currentDescriptor = (StorageApiDynamicDestinations.DescriptorWrapper)SplittingIterable.this.updateSchema.apply(payload.getSchemaHash());
                        try {
                            DynamicMessage msg = DynamicMessage.parseFrom((Descriptors.Descriptor)((SplittingIterable)SplittingIterable.this).currentDescriptor.descriptor, (byte[])payload.getPayload());
                            if (msg.getUnknownFields() != null && !msg.getUnknownFields().asMap().isEmpty()) {
                                throw new RuntimeException("Record schema does not match table. Unknown fields: " + msg.getUnknownFields());
                            }
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ByteString byteString = ByteString.copyFrom((byte[])payload.getPayload());
                    inserts.addSerializedRows(byteString);
                    if ((bytesSize += (long)byteString.size()) <= SplittingIterable.this.splitSize) continue;
                    break;
                }
                return inserts.build();
            }
        };
    }
}

