/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV3;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicDestinationsHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicDestinationsHelpers.class);

    DynamicDestinationsHelpers() {
    }

    static <T, DestinationT> DynamicDestinations<T, DestinationT> matchTableDynamicDestinations(DynamicDestinations<T, DestinationT> inner, BigQueryServices bqServices) {
        return new MatchTableDynamicDestinations(inner, bqServices);
    }

    static class MatchTableDynamicDestinations<T, DestinationT>
    extends DelegatingDynamicDestinations<T, DestinationT> {
        private final BigQueryServices bqServices;

        private MatchTableDynamicDestinations(DynamicDestinations<T, DestinationT> inner, BigQueryServices bqServices) {
            super(inner);
            this.bqServices = bqServices;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private @Nullable Table getBigQueryTable(TableReference tableReference) {
            BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxBackoff(Duration.standardSeconds((long)2L)).backoff());
            try {
                do {
                    try {
                        PipelineOptions options = this.getPipelineOptions();
                        if (options == null) {
                            throw new IllegalStateException("pipeline options cannot be null");
                        }
                        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                        if (tableReference.getProjectId() == null) {
                            tableReference.setProjectId(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject());
                        }
                        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);){
                            Table table = datasetService.getTable(tableReference);
                            return table;
                        }
                        catch (IOException | InterruptedException e) {
                            LOG.info("Failed to get BigQuery table " + tableReference);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } while (MatchTableDynamicDestinations.nextBackOff(Sleeper.DEFAULT, backoff));
                return null;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean nextBackOff(Sleeper sleeper, BackOff backoff) throws InterruptedException {
            try {
                return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public TableDestination getTable(DestinationT destination) {
            TableDestination wrappedDestination = super.getTable(destination);
            Table existingTable = this.getBigQueryTable(wrappedDestination.getTableReference());
            if (existingTable == null) {
                return wrappedDestination;
            }
            return new TableDestination(wrappedDestination.getTableSpec(), existingTable.getDescription(), existingTable.getTimePartitioning(), existingTable.getClustering());
        }

        @Override
        public @Nullable TableSchema getSchema(DestinationT destination) {
            TableDestination wrappedDestination = super.getTable(destination);
            @Nullable Table existingTable = this.getBigQueryTable(wrappedDestination.getTableReference());
            if (existingTable == null) {
                return super.getSchema(destination);
            }
            return existingTable.getSchema();
        }
    }

    static class SchemaFromViewDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        PCollectionView<Map<String, String>> schemaView;

        SchemaFromViewDestinations(DynamicDestinations<T, TableDestination> inner, PCollectionView<Map<String, String>> schemaView) {
            super(inner);
            Preconditions.checkArgument((schemaView != null ? 1 : 0) != 0, (Object)"schemaView can not be null");
            this.schemaView = schemaView;
        }

        @Override
        public List<PCollectionView<?>> getSideInputs() {
            return ImmutableList.builder().add(this.schemaView).build();
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            Map<String, String> mapValue = this.sideInput(this.schemaView);
            String schema = mapValue.get(destination.getTableSpec());
            org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)schema, (String)"Schema view must contain data for every destination used, but view %s does not contain data for table destination %s produced by %s", this.schemaView, (Object)destination.getTableSpec(), (Object)this.inner);
            return BigQueryHelpers.fromJsonString(schema, TableSchema.class);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("schemaView", this.schemaView).toString();
        }
    }

    static class ConstantTimePartitioningDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        private final ValueProvider<String> jsonTimePartitioning;
        private final @Nullable ValueProvider<String> jsonClustering;

        ConstantTimePartitioningDestinations(DynamicDestinations<T, TableDestination> inner, ValueProvider<String> jsonTimePartitioning, ValueProvider<String> jsonClustering) {
            super(inner);
            org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(jsonTimePartitioning, (Object)"jsonTimePartitioning provider can not be null");
            if (jsonTimePartitioning.isAccessible()) {
                org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)((String)jsonTimePartitioning.get()), (Object)"jsonTimePartitioning can not be null");
            }
            this.jsonTimePartitioning = jsonTimePartitioning;
            this.jsonClustering = jsonClustering;
        }

        @Override
        public TableDestination getDestination(@Nullable ValueInSingleWindow<T> element) {
            TableDestination destination = (TableDestination)super.getDestination(element);
            String partitioning = (String)this.jsonTimePartitioning.get();
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"jsonTimePartitioning can not be null");
            return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), partitioning, (String)Optional.ofNullable(this.jsonClustering).map(ValueProvider::get).orElse(null));
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            if (this.jsonClustering != null) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }

        @Override
        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("jsonTimePartitioning", this.jsonTimePartitioning);
            if (this.jsonClustering != null) {
                helper.add("jsonClustering", this.jsonClustering);
            }
            return helper.toString();
        }
    }

    static class ConstantSchemaDestinations<T, DestinationT>
    extends DelegatingDynamicDestinations<T, DestinationT> {
        private final ValueProvider<String> jsonSchema;

        ConstantSchemaDestinations(DynamicDestinations<T, DestinationT> inner, ValueProvider<String> jsonSchema) {
            super(inner);
            org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(jsonSchema, (Object)"jsonSchema can not be null");
            this.jsonSchema = jsonSchema;
        }

        @Override
        public TableSchema getSchema(DestinationT destination) {
            String jsonSchema = (String)this.jsonSchema.get();
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return BigQueryHelpers.fromJsonString(jsonSchema, TableSchema.class);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("jsonSchema", this.jsonSchema).toString();
        }
    }

    static class DelegatingDynamicDestinations<T, DestinationT>
    extends DynamicDestinations<T, DestinationT> {
        final DynamicDestinations<T, DestinationT> inner;

        DelegatingDynamicDestinations(DynamicDestinations<T, DestinationT> inner) {
            this.inner = inner;
        }

        @Override
        public DestinationT getDestination(@Nullable ValueInSingleWindow<T> element) {
            return this.inner.getDestination(element);
        }

        @Override
        public @Nullable TableSchema getSchema(DestinationT destination) {
            return this.inner.getSchema(destination);
        }

        @Override
        public TableDestination getTable(DestinationT destination) {
            return this.inner.getTable(destination);
        }

        @Override
        public @Nullable Coder<DestinationT> getDestinationCoder() {
            return this.inner.getDestinationCoder();
        }

        @Override
        Coder<DestinationT> getDestinationCoderWithDefault(CoderRegistry registry) throws CannotProvideCoderException {
            Coder<DestinationT> destinationCoder = this.getDestinationCoder();
            if (destinationCoder != null) {
                return destinationCoder;
            }
            return this.inner.getDestinationCoderWithDefault(registry);
        }

        @Override
        public List<PCollectionView<?>> getSideInputs() {
            return this.inner.getSideInputs();
        }

        @Override
        void setSideInputAccessorFromProcessContext(DoFn.ProcessContext context) {
            super.setSideInputAccessorFromProcessContext(context);
            this.inner.setSideInputAccessorFromProcessContext(context);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", this.inner).toString();
        }
    }

    static class TableFunctionDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final SerializableFunction<@Nullable ValueInSingleWindow<T>, TableDestination> tableFunction;
        private final boolean clusteringEnabled;

        TableFunctionDestinations(SerializableFunction<@Nullable ValueInSingleWindow<T>, TableDestination> tableFunction, boolean clusteringEnabled) {
            this.tableFunction = tableFunction;
            this.clusteringEnabled = clusteringEnabled;
        }

        @Override
        public TableDestination getDestination(@Nullable ValueInSingleWindow<T> element) {
            TableDestination res = (TableDestination)this.tableFunction.apply(element);
            Preconditions.checkArgument((res != null ? 1 : 0) != 0, (String)"result of tableFunction can not be null, but %s returned null for element: %s", this.tableFunction, element);
            return res;
        }

        @Override
        public @Nullable TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            if (this.clusteringEnabled) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }
    }

    static class ConstantTableDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final ValueProvider<String> tableSpec;
        private final @Nullable String tableDescription;
        private final boolean clusteringEnabled;

        ConstantTableDestinations(ValueProvider<String> tableSpec, @Nullable String tableDescription, boolean clusteringEnabled) {
            this.tableSpec = tableSpec;
            this.tableDescription = tableDescription;
            this.clusteringEnabled = clusteringEnabled;
        }

        static <T> ConstantTableDestinations<T> fromTableSpec(ValueProvider<String> tableSpec, String tableDescription, boolean clusteringEnabled) {
            return new ConstantTableDestinations<T>(tableSpec, tableDescription, clusteringEnabled);
        }

        static <T> ConstantTableDestinations<T> fromJsonTableRef(ValueProvider<String> jsonTableRef, String tableDescription, boolean clusteringEnabled) {
            return new ConstantTableDestinations<T>((ValueProvider<String>)ValueProvider.NestedValueProvider.of(jsonTableRef, (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableSpec()), tableDescription, clusteringEnabled);
        }

        @Override
        public TableDestination getDestination(@Nullable ValueInSingleWindow<T> element) {
            String tableSpec = (String)this.tableSpec.get();
            Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return new TableDestination(tableSpec, this.tableDescription);
        }

        @Override
        public @Nullable TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            if (this.clusteringEnabled) {
                return TableDestinationCoderV3.of();
            }
            return TableDestinationCoderV2.of();
        }
    }
}

