/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class UseAttributeSets
extends Instruction {
    private AttributeSet[] attributeSets;

    public UseAttributeSets(AttributeSet[] attributeSetArray) {
        this.attributeSets = attributeSetArray;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.ATTRIBUTE;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        AttributeSet.expand(this.attributeSets, xPathContext);
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "use attribute sets");
    }
}

