/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class NamePart
extends SystemFunction {
    public static final int NAME = 0;
    public static final int LOCAL_NAME = 1;
    public static final int NAMESPACE_URI = 2;
    public static final int GENERATE_ID = 3;
    public static final int DOCUMENT_URI = 4;
    public static final int NODE_NAME = 6;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments(staticContext);
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        if (this.operation == 3) {
            return n & 0xFFBFFFFF;
        }
        return n;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
        if (nodeInfo == null) {
            if (this.operation == 6 || this.operation == 4) {
                return null;
            }
            if (this.operation == 2) {
                return AnyURIValue.EMPTY_URI;
            }
            return StringValue.EMPTY_STRING;
        }
        switch (this.operation) {
            case 0: {
                string = nodeInfo.getDisplayName();
                break;
            }
            case 1: {
                string = nodeInfo.getLocalPart();
                break;
            }
            case 2: {
                String string2 = nodeInfo.getURI();
                String string3 = string2 == null ? "" : string2;
                return new AnyURIValue(string3);
            }
            case 3: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                nodeInfo.generateId(fastStringBuffer);
                return new StringValue(fastStringBuffer);
            }
            case 4: {
                if (nodeInfo.getNodeKind() == 9) {
                    DocumentPool documentPool = xPathContext.getController().getDocumentPool();
                    String string4 = documentPool.getDocumentURI(nodeInfo);
                    if (string4 == null) {
                        return null;
                    }
                    return StringValue.makeStringValue(string4);
                }
                return null;
            }
            case 6: {
                int n = nodeInfo.getNameCode();
                if (n == -1) {
                    return null;
                }
                return new QNameValue(nodeInfo.getNamePool(), n);
            }
            default: {
                throw new UnsupportedOperationException("Unknown name operation");
            }
        }
        return new StringValue(string);
    }

    public static boolean isGenerateIdFunction(Expression expression) {
        return expression instanceof NamePart && ((NamePart)expression).operation == 3;
    }
}

