/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.denormaliser;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.denormaliser.Denormaliser;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserData;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserGroupField;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserTargetField;

@Transform(id="Denormaliser", image="denormaliser.svg", name="i18n::Denormaliser.Name", description="i18n::Denormaliser.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::DenormaliserMeta.keyword"}, documentationUrl="/pipeline/transforms/rowdenormaliser.html")
public class DenormaliserMeta
extends BaseTransformMeta<Denormaliser, DenormaliserData> {
    private static final Class<?> PKG = DenormaliserMeta.class;
    @HopMetadataProperty(groupKey="group", key="field")
    private List<DenormaliserGroupField> groupFields;
    @HopMetadataProperty(key="key_field", injectionKeyDescription="DenormaliserDialog.KeyField.Label")
    private String keyField;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<DenormaliserTargetField> denormaliserTargetFields;

    public DenormaliserMeta() {
        this.groupFields = new ArrayList<DenormaliserGroupField>();
        this.denormaliserTargetFields = new ArrayList<DenormaliserTargetField>();
    }

    public DenormaliserMeta(DenormaliserMeta m) {
        this.denormaliserTargetFields = m.denormaliserTargetFields;
        this.keyField = m.keyField;
        this.groupFields = m.groupFields;
    }

    public DenormaliserMeta clone() {
        DenormaliserMeta meta = new DenormaliserMeta();
        for (DenormaliserTargetField target : this.denormaliserTargetFields) {
            meta.getDenormaliserTargetFields().add(new DenormaliserTargetField(target));
        }
        return meta;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public List<DenormaliserGroupField> getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(List<DenormaliserGroupField> groupFields) {
        this.groupFields = groupFields;
    }

    public List<DenormaliserTargetField> getDenormaliserTargetFields() {
        return this.denormaliserTargetFields;
    }

    public void setDenormaliserTargetFields(List<DenormaliserTargetField> denormaliserTargetFields) {
        this.denormaliserTargetFields = denormaliserTargetFields;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int idx;
        if (this.keyField != null && this.keyField.length() > 0) {
            idx = row.indexOfValue(this.keyField);
            if (idx < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.UnableToLocateKeyField", (String[])new String[]{this.keyField}));
            }
        } else {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.RequiredKeyField", (String[])new String[0]));
        }
        row.removeValueMeta(idx);
        for (int i = 0; i < this.denormaliserTargetFields.size(); ++i) {
            String fieldname = this.denormaliserTargetFields.get(i).getFieldName();
            if (fieldname != null && fieldname.length() > 0) {
                int idx2 = row.indexOfValue(fieldname);
                if (idx2 < 0) continue;
                row.removeValueMeta(idx2);
                continue;
            }
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.RequiredTargetFieldName", (String[])new String[]{"" + (i + 1)}));
        }
        for (DenormaliserTargetField field : this.denormaliserTargetFields) {
            try {
                IValueMeta target = ValueMetaFactory.createValueMeta((String)field.getTargetName(), (int)ValueMetaFactory.getIdForValueMeta((String)field.getTargetType()));
                target.setLength(field.getTargetLength(), field.getTargetPrecision());
                target.setOrigin(name);
                row.addValueMeta(target);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DenormaliserMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DenormaliserMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

