/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.Difference;

public final class Functions
implements Iterable<Function> {
    private final ImmutableMultimap<FunctionName, Function> functions;

    private Functions(Builder builder) {
        this.functions = builder.functions.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Functions none() {
        return Functions.builder().build();
    }

    public static Functions of(Function ... funs) {
        return Functions.builder().add(funs).build();
    }

    @Override
    public Iterator<Function> iterator() {
        return this.functions.values().iterator();
    }

    public Stream<Function> stream() {
        return this.functions.values().stream();
    }

    public int size() {
        return this.functions.size();
    }

    public Stream<UDFunction> udfs() {
        return this.stream().filter(Filter.UDF).map(f -> (UDFunction)f);
    }

    public Stream<UDAggregate> udas() {
        return this.stream().filter(Filter.UDA).map(f -> (UDAggregate)f);
    }

    public Iterable<Function> referencingUserType(ByteBuffer name) {
        return Iterables.filter((Iterable)this, f -> f.referencesUserType(name));
    }

    public Functions withUpdatedUserType(UserType udt) {
        if (!Iterables.any((Iterable)this, f -> f.referencesUserType(udt.name))) {
            return this;
        }
        Collection udfs = this.udfs().map(f -> f.withUpdatedUserType(udt)).collect(Collectors.toList());
        Collection udas = this.udas().map(f -> f.withUpdatedUserType(udfs, udt)).collect(Collectors.toList());
        return Functions.builder().add(udfs).add(udas).build();
    }

    public Stream<UDAggregate> aggregatesUsingFunction(Function function) {
        return this.udas().filter((? super T uda) -> uda.hasReferenceTo(function));
    }

    public Collection<Function> get(FunctionName name) {
        return this.functions.get((Object)name);
    }

    public Collection<UDFunction> getUdfs(FunctionName name) {
        return this.functions.get((Object)name).stream().filter(Filter.UDF).map(f -> (UDFunction)f).collect(Collectors.toList());
    }

    public Collection<UDAggregate> getUdas(FunctionName name) {
        return this.functions.get((Object)name).stream().filter(Filter.UDA).map(f -> (UDAggregate)f).collect(Collectors.toList());
    }

    public Optional<Function> find(FunctionName name, List<AbstractType<?>> argTypes) {
        return this.find(name, argTypes, Filter.ALL);
    }

    public Optional<Function> find(FunctionName name, List<AbstractType<?>> argTypes, Filter filter) {
        return this.get(name).stream().filter(filter.and(fun -> Functions.typesMatch(fun.argTypes(), argTypes))).findAny();
    }

    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    private static boolean typesMatch(AbstractType<?> t1, AbstractType<?> t2) {
        return t1.freeze().asCQL3Type().toString().equals(t2.freeze().asCQL3Type().toString());
    }

    public static boolean typesMatch(List<AbstractType<?>> t1, List<AbstractType<?>> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        for (int i = 0; i < t1.size(); ++i) {
            if (Functions.typesMatch(t1.get(i), t2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int typeHashCode(AbstractType<?> t) {
        return t.asCQL3Type().toString().hashCode();
    }

    public static int typeHashCode(List<AbstractType<?>> types) {
        int h = 0;
        for (AbstractType<?> type : types) {
            h = h * 31 + Functions.typeHashCode(type);
        }
        return h;
    }

    public Functions filter(Predicate<Function> predicate) {
        Builder builder = Functions.builder();
        this.stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    public Functions with(Function fun) {
        if (this.find(fun.name(), fun.argTypes()).isPresent()) {
            throw new IllegalStateException(String.format("Function %s already exists", fun.name()));
        }
        return Functions.builder().add(this).add(fun).build();
    }

    public Functions without(FunctionName name, List<AbstractType<?>> argTypes) {
        Function fun = this.find(name, argTypes).orElseThrow(() -> new IllegalStateException(String.format("Function %s doesn't exists", name)));
        return this.without(fun);
    }

    public Functions without(Function function) {
        return Functions.builder().add(Iterables.filter((Iterable)this, f -> f != function)).build();
    }

    public Functions withAddedOrUpdated(Function function) {
        return Functions.builder().add(Iterables.filter((Iterable)this, f -> !f.name().equals(function.name()) || !Functions.typesMatch(f.argTypes(), function.argTypes()))).add(function).build();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Functions && this.functions.equals(((Functions)o).functions);
    }

    public int hashCode() {
        return this.functions.hashCode();
    }

    public String toString() {
        return this.functions.values().toString();
    }

    static FunctionsDiff<UDFunction> udfsDiff(Functions before, Functions after) {
        return FunctionsDiff.diff(before, after, Filter.UDF);
    }

    static FunctionsDiff<UDAggregate> udasDiff(Functions before, Functions after) {
        return FunctionsDiff.diff(before, after, Filter.UDA);
    }

    public static final class FunctionsDiff<T extends Function>
    extends Diff<Functions, T> {
        static final FunctionsDiff NONE = new FunctionsDiff(Functions.none(), Functions.none(), ImmutableList.of());

        private FunctionsDiff(Functions created, Functions dropped, ImmutableCollection<Diff.Altered<T>> altered) {
            super(created, dropped, altered);
        }

        private static FunctionsDiff diff(Functions before, Functions after, Filter filter) {
            if (before == after) {
                return NONE;
            }
            Functions created = after.filter(filter.and(k -> !before.find(k.name(), k.argTypes(), filter).isPresent()));
            Functions dropped = before.filter(filter.and(k -> !after.find(k.name(), k.argTypes(), filter).isPresent()));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.stream().filter(filter).forEach(functionBefore -> after.find(functionBefore.name(), functionBefore.argTypes(), filter).ifPresent(functionAfter -> functionBefore.compare((Function)functionAfter).ifPresent(kind -> altered.add(new Diff.Altered<Function>((Function)functionBefore, (Function)functionAfter, (Difference)((Object)((Object)((Object)kind))))))));
            return new FunctionsDiff(created, dropped, altered.build());
        }
    }

    public static final class Builder {
        final ImmutableMultimap.Builder<FunctionName, Function> functions = new ImmutableMultimap.Builder();

        private Builder() {
            this.functions.orderValuesBy(Comparator.comparingInt(Object::hashCode));
        }

        public Functions build() {
            return new Functions(this);
        }

        public Builder add(Function fun) {
            this.functions.put((Object)fun.name(), (Object)fun);
            return this;
        }

        public Builder add(Function ... funs) {
            for (Function fun : funs) {
                this.add(fun);
            }
            return this;
        }

        public Builder add(Iterable<? extends Function> funs) {
            funs.forEach(this::add);
            return this;
        }
    }

    public static enum Filter implements Predicate<Function>
    {
        ALL,
        UDF,
        UDA;


        @Override
        public boolean test(Function function) {
            switch (this) {
                case UDF: {
                    return function instanceof UDFunction;
                }
                case UDA: {
                    return function instanceof UDAggregate;
                }
            }
            return true;
        }
    }
}

