/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class UnownedInputStream
extends FilterInputStream {
    public UnownedInputStream(InputStream delegate) {
        super(delegate);
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call close().");
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof UnownedInputStream && ((UnownedInputStream)obj).in.equals(this.in);
    }

    public int hashCode() {
        return this.in.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call mark().");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("Caller does not own the underlying input stream  and should not call reset().");
    }

    public String toString() {
        return MoreObjects.toStringHelper(UnownedInputStream.class).add("in", (Object)this.in).toString();
    }
}

