/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampTransform;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterProcessingTime
extends Trigger.OnceTrigger {
    private static final PeriodFormatter DURATION_FORMATTER = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    private final List<TimestampTransform> timestampTransforms;

    private AfterProcessingTime(List<TimestampTransform> timestampTransforms) {
        super(null);
        this.timestampTransforms = timestampTransforms;
    }

    public static AfterProcessingTime pastFirstElementInPane() {
        return new AfterProcessingTime(Collections.emptyList());
    }

    public List<TimestampTransform> getTimestampTransforms() {
        return this.timestampTransforms;
    }

    public AfterProcessingTime plusDelayOf(Duration delay) {
        return new AfterProcessingTime((List<TimestampTransform>)ImmutableList.builder().addAll(this.timestampTransforms).add((Object)TimestampTransform.delay(delay)).build());
    }

    public AfterProcessingTime alignedTo(Duration period, Instant offset) {
        return new AfterProcessingTime((List<TimestampTransform>)ImmutableList.builder().addAll(this.timestampTransforms).add((Object)TimestampTransform.alignTo(period, offset)).build());
    }

    public AfterProcessingTime alignedTo(Duration period) {
        return this.alignedTo(period, new Instant(0L));
    }

    @Override
    public boolean isCompatible(Trigger other) {
        return this.equals(other);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return AfterSynchronizedProcessingTime.ofFirstElement();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (TimestampTransform transform : this.getTimestampTransforms()) {
            if (transform instanceof TimestampTransform.Delay) {
                TimestampTransform.Delay delay = (TimestampTransform.Delay)transform;
                builder.append(".plusDelayOf(").append(DURATION_FORMATTER.print((ReadablePeriod)delay.getDelay().toPeriod())).append(")");
                continue;
            }
            if (!(transform instanceof TimestampTransform.AlignTo)) continue;
            TimestampTransform.AlignTo alignTo = (TimestampTransform.AlignTo)transform;
            builder.append(".alignedTo(").append(DURATION_FORMATTER.print((ReadablePeriod)alignTo.getPeriod().toPeriod())).append(", ").append(alignTo.getOffset()).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTime)) {
            return false;
        }
        AfterProcessingTime that = (AfterProcessingTime)obj;
        return this.getTimestampTransforms().equals(that.getTimestampTransforms());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTimestampTransforms());
    }
}

