/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.WindowSupplier;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Duration;

final class StaticWindows
extends NonMergingWindowFn<Object, BoundedWindow> {
    private final Supplier<Collection<BoundedWindow>> windows;
    private final Coder<BoundedWindow> coder;
    private final boolean onlyExisting;

    private StaticWindows(Supplier<Collection<BoundedWindow>> windows, Coder<BoundedWindow> coder, boolean onlyExisting) {
        this.windows = windows;
        this.coder = coder;
        this.onlyExisting = onlyExisting;
    }

    public static <W extends BoundedWindow> StaticWindows of(Coder<W> coder, Iterable<W> windows) {
        Preconditions.checkArgument((!Iterables.isEmpty(windows) ? 1 : 0) != 0, (Object)"Input windows to StaticWindows may not be empty");
        StaticWindows windowFn = new StaticWindows(WindowSupplier.of(coder, windows), coder, false);
        return windowFn;
    }

    public static <W extends BoundedWindow> StaticWindows of(Coder<W> coder, W window) {
        return StaticWindows.of(coder, Collections.singleton(window));
    }

    public StaticWindows intoOnlyExisting() {
        return new StaticWindows(this.windows, this.coder, true);
    }

    public Collection<BoundedWindow> getWindows() {
        return (Collection)this.windows.get();
    }

    @Override
    public Collection<BoundedWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        if (this.onlyExisting) {
            Preconditions.checkArgument((boolean)((Collection)this.windows.get()).contains(c.window()), (Object)"Tried to assign windows to an element that is not already windowed into a provided window when onlyExisting is set to true");
            return Collections.singleton(c.window());
        }
        return this.getWindows();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        if (!(other instanceof StaticWindows)) {
            return false;
        }
        StaticWindows that = (StaticWindows)other;
        return Objects.equals(this.windows.get(), that.windows.get());
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same window supplier are compatible.", StaticWindows.class.getSimpleName()));
        }
    }

    @Override
    public Coder<BoundedWindow> windowCoder() {
        return this.coder;
    }

    @Override
    public WindowMappingFn<BoundedWindow> getDefaultWindowMappingFn() {
        return new WindowMappingFn<BoundedWindow>(Duration.millis((long)Long.MAX_VALUE)){

            @Override
            public BoundedWindow getSideInputWindow(BoundedWindow mainWindow) {
                Preconditions.checkArgument((boolean)((Collection)StaticWindows.this.windows.get()).contains(mainWindow), (String)"%s only supports side input windows for main input windows that it contains", (Object)StaticWindows.class.getSimpleName());
                return mainWindow;
            }
        };
    }

    @Override
    public boolean assignsToOneWindow() {
        return true;
    }
}

