/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JsonUtils {
    public static SimpleFunction<byte[], Row> getJsonBytesToRowFunction(Schema beamSchema) {
        return new JsonToRowFn<byte[]>(beamSchema){

            @Override
            public Row apply(byte[] input) {
                String jsonString = JsonUtils.byteArrayToJsonString(input);
                return RowJsonUtils.jsonToRow(this.objectMapper, jsonString);
            }
        };
    }

    public static SimpleFunction<String, Row> getJsonStringToRowFunction(Schema beamSchema) {
        return new JsonToRowFn<String>(beamSchema){

            @Override
            public Row apply(String jsonString) {
                return RowJsonUtils.jsonToRow(this.objectMapper, jsonString);
            }
        };
    }

    public static SimpleFunction<Row, byte[]> getRowToJsonBytesFunction(Schema beamSchema) {
        return new RowToJsonFn<byte[]>(beamSchema){

            @Override
            public byte[] apply(Row input) {
                String jsonString = RowJsonUtils.rowToJson(this.objectMapper, input);
                return JsonUtils.jsonStringToByteArray(jsonString);
            }
        };
    }

    public static SimpleFunction<Row, String> getRowToJsonStringsFunction(Schema beamSchema) {
        return new RowToJsonFn<String>(beamSchema){

            @Override
            public String apply(Row input) {
                return RowJsonUtils.rowToJson(this.objectMapper, input);
            }
        };
    }

    static byte[] jsonStringToByteArray(String jsonString) {
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }

    static String byteArrayToJsonString(byte[] jsonBytes) {
        return new String(jsonBytes, StandardCharsets.UTF_8);
    }

    private static abstract class RowToJsonFn<T>
    extends SimpleFunction<Row, T> {
        final RowJson.RowJsonSerializer serializer;
        final ObjectMapper objectMapper;

        private RowToJsonFn(Schema beamSchema) {
            this.serializer = RowJson.RowJsonSerializer.forSchema(beamSchema);
            this.objectMapper = RowJsonUtils.newObjectMapperWith(this.serializer);
        }
    }

    private static abstract class JsonToRowFn<T>
    extends SimpleFunction<T, Row> {
        final RowJson.RowJsonDeserializer deserializer;
        final ObjectMapper objectMapper;

        private JsonToRowFn(Schema beamSchema) {
            this.deserializer = RowJson.RowJsonDeserializer.forSchema(beamSchema);
            this.objectMapper = RowJsonUtils.newObjectMapperWith(this.deserializer);
        }
    }
}

