/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.io.AvroSink;
import org.apache.beam.sdk.io.DynamicAvroDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConstantAvroDestination<UserT, OutputT>
extends DynamicAvroDestinations<UserT, Void, OutputT> {
    private static final int METADATA_BYTES_MAX_LENGTH = 40;
    private final FileBasedSink.FilenamePolicy filenamePolicy;
    private final Supplier<Schema> schema;
    private final Map<String, Object> metadata;
    private final SerializableAvroCodecFactory codec;
    private final SerializableFunction<UserT, OutputT> formatFunction;
    private final AvroSink.DatumWriterFactory<OutputT> datumWriterFactory;

    public ConstantAvroDestination(FileBasedSink.FilenamePolicy filenamePolicy, Schema schema, Map<String, Object> metadata, CodecFactory codec, SerializableFunction<UserT, OutputT> formatFunction) {
        this(filenamePolicy, schema, metadata, codec, formatFunction, null);
    }

    public ConstantAvroDestination(FileBasedSink.FilenamePolicy filenamePolicy, Schema schema, Map<String, Object> metadata, CodecFactory codec, SerializableFunction<UserT, OutputT> formatFunction, @Nullable AvroSink.DatumWriterFactory<OutputT> datumWriterFactory) {
        this.filenamePolicy = filenamePolicy;
        this.schema = Suppliers.compose((Function)new SchemaFunction(), (Supplier)Suppliers.ofInstance((Object)schema.toString()));
        this.metadata = metadata;
        this.codec = new SerializableAvroCodecFactory(codec);
        this.formatFunction = formatFunction;
        this.datumWriterFactory = datumWriterFactory;
    }

    @Override
    public OutputT formatRecord(UserT record) {
        return this.formatFunction.apply(record);
    }

    @Override
    public @Nullable Void getDestination(UserT element) {
        return null;
    }

    @Override
    public @Nullable Void getDefaultDestination() {
        return null;
    }

    @Override
    public FileBasedSink.FilenamePolicy getFilenamePolicy(Void destination) {
        return this.filenamePolicy;
    }

    @Override
    public Schema getSchema(Void destination) {
        return (Schema)this.schema.get();
    }

    @Override
    public Map<String, Object> getMetadata(Void destination) {
        return this.metadata;
    }

    @Override
    public CodecFactory getCodec(Void destination) {
        return this.codec.getCodec();
    }

    @Override
    public @Nullable AvroSink.DatumWriterFactory<OutputT> getDatumWriterFactory(Void destination) {
        return this.datumWriterFactory;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        this.filenamePolicy.populateDisplayData(builder);
        builder.add(DisplayData.item("schema", ((Schema)this.schema.get()).toString()).withLabel("Record Schema"));
        builder.addIfNotDefault(DisplayData.item("codec", this.codec.getCodec().toString()).withLabel("Avro Compression Codec"), AvroIO.TypedWrite.DEFAULT_SERIALIZABLE_CODEC.toString());
        builder.include("Metadata", new Metadata());
    }

    private class Metadata
    implements HasDisplayData {
        private Metadata() {
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            for (Map.Entry entry : ConstantAvroDestination.this.metadata.entrySet()) {
                DisplayData.Type type = DisplayData.inferType(entry.getValue());
                if (type != null) {
                    builder.add(DisplayData.item((String)entry.getKey(), type, entry.getValue()));
                    continue;
                }
                String base64 = BaseEncoding.base64().encode((byte[])entry.getValue());
                String repr = base64.length() <= 40 ? base64 : base64.substring(0, 40) + "...";
                builder.add(DisplayData.item((String)entry.getKey(), repr));
            }
        }
    }

    private static class SchemaFunction
    implements Serializable,
    Function<String, Schema> {
        private SchemaFunction() {
        }

        public Schema apply(String input) {
            return new Schema.Parser().parse(input);
        }
    }
}

