/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;

public class VarLongCoder
extends StructuredCoder<Long> {
    private static final VarLongCoder INSTANCE = new VarLongCoder();
    private static final TypeDescriptor<Long> TYPE_DESCRIPTOR = new TypeDescriptor<Long>(){};

    public static VarLongCoder of() {
        return INSTANCE;
    }

    private VarLongCoder() {
    }

    @Override
    public void encode(Long value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        VarInt.encode(value, outStream);
    }

    @Override
    public Long decode(InputStream inStream) throws IOException, CoderException {
        try {
            return VarInt.decodeLong(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Collections.emptyList();
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Long value) {
        return true;
    }

    @Override
    public TypeDescriptor<Long> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Long value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        return VarInt.getLength(value);
    }
}

