/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public class DoFnRunnerWithMetricsUpdate<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final String stepName;
    private final FlinkMetricContainer container;
    private final DoFnRunner<InputT, OutputT> delegate;

    public DoFnRunnerWithMetricsUpdate(String stepName, DoFnRunner<InputT, OutputT> delegate, FlinkMetricContainer metricContainer) {
        this.stepName = stepName;
        this.delegate = delegate;
        this.container = metricContainer;
    }

    public void startBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.startBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processElement(WindowedValue<InputT> elem) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.processElement(elem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <KeyT> void onTimer(String timerId, String timerFamilyId, KeyT key, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.finishBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container.updateMetrics(this.stepName);
    }

    public <KeyT> void onWindowExpiration(BoundedWindow window, Instant timestamp, KeyT key) {
        this.delegate.onWindowExpiration(window, timestamp, key);
    }

    public DoFn<InputT, OutputT> getFn() {
        return this.delegate.getFn();
    }
}

