/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class ParquetField {
    @HopMetadataProperty(key="source_field")
    private String sourceField;
    @HopMetadataProperty(key="target_field")
    private String targetField;
    @HopMetadataProperty(key="target_type")
    private String targetType;
    @HopMetadataProperty(key="target_format")
    private String targetFormat;
    @HopMetadataProperty(key="target_length")
    private String targetLength;
    @HopMetadataProperty(key="target_precision")
    private String targetPrecision;

    public ParquetField() {
    }

    public ParquetField(ParquetField f) {
        this.sourceField = f.sourceField;
        this.targetField = f.targetField;
        this.targetType = f.targetType;
        this.targetFormat = f.targetFormat;
        this.targetLength = f.targetLength;
        this.targetPrecision = f.targetPrecision;
    }

    public ParquetField(String sourceField, String targetField, String targetType, String targetFormat, String targetLength, String targetPrecision) {
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.targetType = targetType;
        this.targetFormat = targetFormat;
        this.targetLength = targetLength;
        this.targetPrecision = targetPrecision;
    }

    public IValueMeta createValueMeta() throws HopException {
        int type = ValueMetaFactory.getIdForValueMeta((String)this.targetType);
        int length = Const.toInt((String)this.targetLength, (int)-1);
        int precision = Const.toInt((String)this.targetPrecision, (int)-1);
        IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)this.targetField, (int)type, (int)length, (int)precision);
        valueMeta.setConversionMask(this.targetFormat);
        return valueMeta;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public void setSourceField(String sourceField) {
        this.sourceField = sourceField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetFormat() {
        return this.targetFormat;
    }

    public void setTargetFormat(String targetFormat) {
        this.targetFormat = targetFormat;
    }

    public String getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(String targetLength) {
        this.targetLength = targetLength;
    }

    public String getTargetPrecision() {
        return this.targetPrecision;
    }

    public void setTargetPrecision(String targetPrecision) {
        this.targetPrecision = targetPrecision;
    }
}

