/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32.test;

import org.hyperic.sigar.test.SigarTestCase;
import org.hyperic.sigar.win32.EventLog;
import org.hyperic.sigar.win32.EventLogNotification;
import org.hyperic.sigar.win32.EventLogRecord;
import org.hyperic.sigar.win32.EventLogThread;
import org.hyperic.sigar.win32.Win32Exception;

public class TestEventLog
extends SigarTestCase {
    public TestEventLog(String name) {
        super(name);
    }

    public void testOpenClose() throws Exception {
        EventLog log = new EventLog();
        try {
            log.close();
            TestEventLog.fail((String)"Closing an unopened event log succeeded");
        }
        catch (Win32Exception win32Exception) {
            // empty catch block
        }
        log.open("Application");
        log.close();
        log.open("System");
        log.close();
    }

    public void testGetNumberOfRecords() throws Exception {
        EventLog log = new EventLog();
        log.open("Application");
        try {
            int numRecords = log.getNumberOfRecords();
        }
        catch (Exception e) {
            TestEventLog.fail((String)"Unable to get the number of records");
        }
        log.close();
    }

    public void testGetOldestRecord() throws Exception {
        EventLog log = new EventLog();
        log.open("Application");
        try {
            int oldestRecord = log.getOldestRecord();
        }
        catch (Exception e) {
            TestEventLog.fail((String)"Unable to get the oldest event record");
        }
        log.close();
    }

    public void testGetNewestRecord() throws Exception {
        EventLog log = new EventLog();
        log.open("Application");
        try {
            int newestRecord = log.getNewestRecord();
        }
        catch (Exception e) {
            TestEventLog.fail((String)"Unable to get the newest event record");
        }
        log.close();
    }

    private int readAll(String logname) throws Exception {
        int fail = 0;
        int success = 0;
        int max = 500;
        String testMax = System.getProperty("sigar.testeventlog.max");
        if (testMax != null) {
            max = Integer.parseInt(testMax);
        }
        EventLog log = new EventLog();
        log.open(logname);
        if (log.getNumberOfRecords() == 0) {
            log.close();
            return 0;
        }
        int oldestRecord = log.getOldestRecord();
        int numRecords = log.getNumberOfRecords();
        this.traceln("oldest=" + oldestRecord + ", total=" + numRecords + ", max=" + max);
        for (int i = oldestRecord; i < oldestRecord + numRecords; ++i) {
            try {
                EventLogRecord record = log.read(i);
                if (++success <= max) continue;
                break;
            }
            catch (Win32Exception e) {
                ++fail;
                this.traceln("Error reading record " + i + ": " + e.getMessage());
            }
        }
        log.close();
        this.traceln("success=" + success + ", fail=" + fail);
        return success;
    }

    public void testRead() throws Exception {
        int total = 0;
        String[] logs = EventLog.getLogNames();
        for (int i = 0; i < logs.length; ++i) {
            String msg = "readAll(" + logs[i] + ")";
            this.traceln(msg);
            total += this.readAll(logs[i]);
        }
        if (total == 0) {
            TestEventLog.fail((String)"No eventlog entries read");
        }
    }

    public void testEventLogThread() throws Exception {
        EventLogThread thread = EventLogThread.getInstance("Application");
        thread.doStart();
        SSHEventLogNotification notification = new SSHEventLogNotification();
        thread.add(notification);
        thread.doStop();
    }

    private class SSHEventLogNotification
    implements EventLogNotification {
        private SSHEventLogNotification() {
        }

        public boolean matches(EventLogRecord record) {
            return record.getSource().equals("sshd");
        }

        public void handleNotification(EventLogRecord record) {
            System.out.println(record);
        }
    }
}

