/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseWorkflowServlet;
import org.apache.hop.www.WebResult;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@HopServerServlet(id="registerPackage", name="Upload a resources export file")
public class RegisterPackageServlet
extends BaseWorkflowServlet {
    public static final String CONTEXT_PATH = "/hop/registerPackage";
    private static final long serialVersionUID = -7582587179862317791L;
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_WORKFLOW = "workflow";
    public static final String TYPE_PIPELINE = "pipeline";
    private static final String ZIP_CONT = "zip:{0}!{1}";

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    WebResult generateBody(HttpServletRequest request, HttpServletResponse response, boolean useXML, IVariables variables) throws HopException, IOException, HopException, ParseException {
        FileObject tempFile = HopVfs.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
        OutputStream out = HopVfs.getOutputStream((FileObject)tempFile, (boolean)false);
        IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((OutputStream)out);
        String archiveUrl = tempFile.getName().toString();
        String load = request.getParameter(PARAMETER_LOAD);
        if (!Utils.isEmpty((CharSequence)load)) {
            String resultId;
            String fileUrl = MessageFormat.format(ZIP_CONT, archiveUrl, load);
            boolean isWorkflow = TYPE_WORKFLOW.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
            String metaStoreJson = RegisterPackageServlet.getMetaStoreJsonFromZIP(archiveUrl);
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metaStoreJson);
            if (isWorkflow) {
                Node node = this.getConfigNodeFromZIP(archiveUrl, "__workflow_execution_configuration__.xml", "workflow_execution_configuration");
                WorkflowExecutionConfiguration workflowExecutionConfiguration = new WorkflowExecutionConfiguration(node);
                WorkflowMeta workflowMeta = new WorkflowMeta(Variables.getADefaultVariableSpace(), fileUrl, metadataProvider);
                WorkflowConfiguration workflowConfiguration = new WorkflowConfiguration(workflowMeta, workflowExecutionConfiguration, metadataProvider);
                IWorkflowEngine<WorkflowMeta> workflow = this.createWorkflow(workflowConfiguration);
                resultId = workflow.getContainerId();
            } else {
                Node node = this.getConfigNodeFromZIP(archiveUrl, "__job_execution_configuration__.xml", "pipeline_execution_configuration");
                PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration(node);
                PipelineMeta pipelineMeta = new PipelineMeta(fileUrl, (IHopMetadataProvider)metadataProvider, Variables.getADefaultVariableSpace());
                PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(pipelineMeta, pipelineExecutionConfiguration, metadataProvider);
                IPipelineEngine<PipelineMeta> pipeline = this.createPipeline(pipelineConfiguration);
                resultId = pipeline.getContainerId();
            }
            return new WebResult("OK", fileUrl, resultId);
        }
        return null;
    }

    @Override
    protected boolean useXML(HttpServletRequest request) {
        return true;
    }

    protected Node getConfigNodeFromZIP(Object archiveUrl, Object fileName, String xmlTag) throws HopXmlException {
        String configUrl = MessageFormat.format(ZIP_CONT, archiveUrl, fileName);
        Document configDoc = XmlHandler.loadXmlFile((String)configUrl);
        return XmlHandler.getSubNode((Node)configDoc, (String)xmlTag);
    }

    public static final String getMetaStoreJsonFromZIP(Object archiveUrl) throws HopFileException, IOException {
        String filename = MessageFormat.format(ZIP_CONT, archiveUrl, "metadata.json");
        InputStream inputStream = HopVfs.getInputStream((String)filename);
        String metaStoreJson = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
        return metaStoreJson;
    }
}

