/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@GuiPlugin
@HopMetadata(key="cassandra-connection", name="Cassandra Connection", description="Describes a connection to a Cassandra cluster", image="Cassandra_logo.svg", documentationUrl="/metadata-types/cassandra/cassandra-connection.html")
public class CassandraConnection
extends HopMetadataBase
implements IHopMetadata {
    public static final String WIDGET_ID_HOSTNAME = "10000-hostname";
    public static final String WIDGET_ID_PORT = "10100-port";
    public static final String WIDGET_ID_DATA_CENTER = "10150-data-center";
    public static final String WIDGET_ID_USERNAME = "10200-username";
    public static final String WIDGET_ID_PASSWORD = "10300-password";
    public static final String WIDGET_ID_SOCKET_TIMEOUT = "10400-socket-timeout";
    public static final String WIDGET_ID_KEYSPACE = "10500-keyspace";
    public static final String WIDGET_ID_SCHEMA_HOSTNAME = "10800-schema-hostname";
    public static final String WIDGET_ID_SCHEMA_PORT = "10900-schema-port";
    public static final String WIDGET_ID_USE_COMPRESSION = "11000-use-compression";
    @HopMetadataProperty
    @GuiWidgetElement(id="10000-hostname", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Hostname", toolTip="Specify the hostname of your cassandra server")
    private String hostname;
    @HopMetadataProperty
    @GuiWidgetElement(id="10100-port", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Port", toolTip="The default port of a cassandra server is 9042")
    private String port = "9042";
    @HopMetadataProperty
    @GuiWidgetElement(id="10150-data-center", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Local data center", toolTip="The local data center needs to be specified when you connect to specific hostname(s), aka contact points")
    private String localDataCenter;
    @HopMetadataProperty
    @GuiWidgetElement(id="10200-username", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Username", toolTip="The user to log in with")
    private String username;
    @HopMetadataProperty
    @GuiWidgetElement(id="10300-password", type=GuiElementType.TEXT, password=true, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Password", toolTip="The password to log in with")
    private String password;
    @HopMetadataProperty
    @GuiWidgetElement(id="10400-socket-timeout", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Socket timeout", toolTip="The socket timeout to use")
    private String socketTimeout;
    @HopMetadataProperty
    @GuiWidgetElement(id="10500-keyspace", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Keyspace", toolTip="The keyspace to use")
    private String keyspace;
    @HopMetadataProperty
    @GuiWidgetElement(id="10800-schema-hostname", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Schema hostname", toolTip="The Cassandra node to put schema updates through")
    private String schemaHostname;
    @HopMetadataProperty
    @GuiWidgetElement(id="10900-schema-port", type=GuiElementType.TEXT, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Schema port", toolTip="The port of the Cassandra node to put schema updates through")
    private String schemaPort = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11000-use-compression", type=GuiElementType.CHECKBOX, parentId="CassandraConnectionEditor.Widgets.ParentId", label="Using compression?", toolTip="Check this option if you want to use compression over the connection")
    private boolean usingCompression;

    public CassandraConnection() {
    }

    public CassandraConnection(CassandraConnection c) {
        super(c.name);
        this.hostname = c.hostname;
        this.port = c.port;
        this.username = c.username;
        this.password = c.password;
        this.socketTimeout = c.socketTimeout;
        this.keyspace = c.keyspace;
        this.schemaHostname = c.schemaHostname;
        this.schemaPort = c.schemaPort;
        this.usingCompression = c.usingCompression;
    }

    public DriverConnection createConnection(IVariables variables, boolean output) throws Exception {
        return this.createConnection(variables, this.getOptionsMap(variables), output);
    }

    public DriverConnection createConnection(IVariables variables, Map<String, String> options, boolean output) throws Exception {
        String chosenHostname = variables.resolve(this.hostname);
        String chosenPort = variables.resolve(this.port);
        if (output) {
            if (StringUtils.isNotEmpty((String)this.schemaHostname)) {
                chosenHostname = variables.resolve(this.schemaHostname);
            }
            if (StringUtils.isNotEmpty((String)this.schemaPort)) {
                chosenPort = variables.resolve(this.schemaPort);
            }
        }
        return CassandraUtils.getCassandraConnection(chosenHostname, Const.toInt((String)chosenPort, (int)9042), variables.resolve(this.localDataCenter), variables.resolve(this.username), variables.resolve(this.password), options);
    }

    public Map<String, String> getOptionsMap(IVariables variables) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (!Utils.isEmpty((CharSequence)this.socketTimeout)) {
            options.put("socketTimeout", variables.resolve(this.socketTimeout));
        }
        if (this.usingCompression) {
            options.put("compression", Boolean.TRUE.toString());
        }
        return options;
    }

    public Keyspace lookupKeyspace(DriverConnection connection, IVariables variables) throws Exception {
        return connection.getKeyspace(variables.resolve(this.keyspace));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLocalDataCenter() {
        return this.localDataCenter;
    }

    public void setLocalDataCenter(String localDataCenter) {
        this.localDataCenter = localDataCenter;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getSchemaHostname() {
        return this.schemaHostname;
    }

    public void setSchemaHostname(String schemaHostname) {
        this.schemaHostname = schemaHostname;
    }

    public String getSchemaPort() {
        return this.schemaPort;
    }

    public void setSchemaPort(String schemaPort) {
        this.schemaPort = schemaPort;
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    public void setUsingCompression(boolean usingCompression) {
        this.usingCompression = usingCompression;
    }
}

