/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.Objects;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.graph.NodeMappingType;

public class NodeMapping {
    @HopMetadataProperty(key="node_mapping_type", injectionKey="node_mapping_type", injectionGroupDescription="GraphOutput.Injection.NODE_MAPPING_TYPE", storeWithCode=true)
    private NodeMappingType type;
    @HopMetadataProperty(key="node_name", injectionKey="node_name", injectionGroupDescription="GraphOutput.Injection.TARGET_NODE_NAME")
    private String targetNode;
    @HopMetadataProperty(key="field_name", injectionKey="field_name", injectionGroupDescription="GraphOutput.Injection.FIELD_NAME")
    private String fieldName;
    @HopMetadataProperty(key="field_value", injectionKey="field_value", injectionGroupDescription="GraphOutput.Injection.FIELD_VALUE")
    private String fieldValue;
    @HopMetadataProperty(key="target_label", injectionKey="target_label", injectionGroupDescription="GraphOutput.Injection.TARGET_NODE_LABEL")
    private String targetLabel;

    public NodeMapping() {
        this.type = NodeMappingType.All;
    }

    public NodeMapping(NodeMappingType type, String targetNode, String fieldName, String fieldValue, String targetLabel) {
        this.type = type;
        this.targetNode = targetNode;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.targetLabel = targetLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMapping that = (NodeMapping)o;
        return this.type == that.type && Objects.equals(this.targetNode, that.targetNode) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.fieldValue, that.fieldValue) && Objects.equals(this.targetLabel, that.targetLabel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.targetNode, this.fieldName, this.fieldValue, this.targetLabel});
    }

    public String toString() {
        return "NodeMapping{type=" + String.valueOf((Object)this.type) + ", targetNode='" + this.targetNode + "', fieldName='" + this.fieldName + "', fieldValue='" + this.fieldValue + "', targetLabel='" + this.targetLabel + "'}";
    }

    public NodeMappingType getType() {
        return this.type;
    }

    public void setType(NodeMappingType type) {
        this.type = type;
    }

    public String getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public void setTargetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
    }
}

