/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class DisplayDataTranslation {
    public static final String LABELLED = "beam:display_data:labelled:v1";
    private static final Map<String, Function<DisplayData.Item, ByteString>> WELL_KNOWN_URN_TRANSLATORS;

    public static List<RunnerApi.DisplayData> toProto(DisplayData displayData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DisplayData.Item item : displayData.items()) {
            String urn;
            Function<DisplayData.Item, ByteString> translator = WELL_KNOWN_URN_TRANSLATORS.get(item.getKey());
            if (translator != null) {
                urn = item.getKey();
            } else {
                urn = LABELLED;
                translator = DisplayDataTranslation::translate;
            }
            builder.add((Object)RunnerApi.DisplayData.newBuilder().setUrn(urn).setPayload(translator.apply(item)).build());
        }
        return builder.build();
    }

    private static ByteString translate(DisplayData.Item item) {
        Object valueObj;
        String label = item.getLabel() == null ? item.getKey() : item.getLabel();
        String namespace = item.getNamespace() == null ? "" : item.getNamespace().getName();
        RunnerApi.LabelledPayload.Builder builder = RunnerApi.LabelledPayload.newBuilder().setKey(item.getKey()).setLabel(label).setNamespace(namespace);
        Object object = valueObj = item.getValue() == null ? item.getShortValue() : item.getValue();
        if (valueObj instanceof Boolean) {
            builder.setBoolValue(((Boolean)valueObj).booleanValue());
        } else if (valueObj instanceof Integer || valueObj instanceof Long) {
            builder.setIntValue(((Long)valueObj).longValue());
        } else if (valueObj instanceof Number) {
            builder.setDoubleValue(((Number)valueObj).doubleValue());
        } else {
            builder.setStringValue(String.valueOf(valueObj));
        }
        return builder.build().toByteString();
    }

    static {
        Preconditions.checkState((boolean)LABELLED.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardDisplayData.DisplayData.LABELLED)));
        WELL_KNOWN_URN_TRANSLATORS = ImmutableMap.of((Object)LABELLED, DisplayDataTranslation::translate);
    }
}

