/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Comparator;
import java.util.Locale;
import org.apache.cassandra.cql3.ColumnIdentifier;

public interface SchemaElement {
    public static final Comparator<SchemaElement> NAME_COMPARATOR = (o1, o2) -> o1.elementName().compareToIgnoreCase(o2.elementName());

    public SchemaElementType elementType();

    public String elementKeyspace();

    public String elementName();

    default public String elementNameQuotedIfNeeded() {
        String name = this.elementName();
        if (this.elementType() == SchemaElementType.FUNCTION || this.elementType() == SchemaElementType.AGGREGATE) {
            int index = name.indexOf(40);
            return ColumnIdentifier.maybeQuote(name.substring(0, index)) + name.substring(index);
        }
        return ColumnIdentifier.maybeQuote(name);
    }

    default public String elementKeyspaceQuotedIfNeeded() {
        return ColumnIdentifier.maybeQuote(this.elementKeyspace());
    }

    public String toCqlString(boolean var1, boolean var2);

    public static enum SchemaElementType {
        KEYSPACE,
        TYPE,
        FUNCTION,
        AGGREGATE,
        TABLE,
        INDEX,
        MATERIALIZED_VIEW;


        public String toString() {
            return super.toString().toLowerCase(Locale.US);
        }
    }
}

