/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum NamespaceType {
    APP_FOLDER,
    SHARED_FOLDER,
    TEAM_FOLDER,
    TEAM_MEMBER_FOLDER,
    OTHER;


    static class Serializer
    extends UnionSerializer<NamespaceType> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(NamespaceType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case APP_FOLDER: {
                    g.writeString("app_folder");
                    break;
                }
                case SHARED_FOLDER: {
                    g.writeString("shared_folder");
                    break;
                }
                case TEAM_FOLDER: {
                    g.writeString("team_folder");
                    break;
                }
                case TEAM_MEMBER_FOLDER: {
                    g.writeString("team_member_folder");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public NamespaceType deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            NamespaceType value = "app_folder".equals(tag) ? APP_FOLDER : ("shared_folder".equals(tag) ? SHARED_FOLDER : ("team_folder".equals(tag) ? TEAM_FOLDER : ("team_member_folder".equals(tag) ? TEAM_MEMBER_FOLDER : OTHER)));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

