/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.Response;
import java.util.Collections;
import java.util.List;

public interface EmbeddingModel {
    default public Response<Embedding> embed(String text) {
        return this.embed(TextSegment.from(text));
    }

    default public Response<Embedding> embed(TextSegment textSegment) {
        Response<List<Embedding>> response = this.embedAll(Collections.singletonList(textSegment));
        ValidationUtils.ensureEq(response.content().size(), 1, "Expected a single embedding, but got %d", response.content().size());
        return Response.from(response.content().get(0), response.tokenUsage(), response.finishReason());
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> var1);
}

