/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ComposeObjectArgs;
import io.minio.CopySource;
import io.minio.Directive;
import io.minio.ObjectWriteArgs;
import java.util.Objects;
import okhttp3.HttpUrl;

public class CopyObjectArgs
extends ObjectWriteArgs {
    private CopySource source = null;
    private Directive metadataDirective;
    private Directive taggingDirective;

    protected CopyObjectArgs() {
    }

    public CopyObjectArgs(ComposeObjectArgs args) {
        this.extraHeaders = args.extraHeaders;
        this.extraQueryParams = args.extraQueryParams;
        this.bucketName = args.bucketName;
        this.region = args.region;
        this.objectName = args.objectName;
        this.headers = args.headers;
        this.userMetadata = args.userMetadata;
        this.sse = args.sse;
        this.tags = args.tags;
        this.retention = args.retention;
        this.legalHold = args.legalHold;
        this.source = new CopySource(args.sources().get(0));
    }

    public CopySource source() {
        return this.source;
    }

    public Directive metadataDirective() {
        return this.metadataDirective;
    }

    public Directive taggingDirective() {
        return this.taggingDirective;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validateSse(HttpUrl url) {
        super.validateSse(url);
        this.source.validateSsec(url);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyObjectArgs that = (CopyObjectArgs)o;
        return Objects.equals(this.source, that.source) && this.metadataDirective == that.metadataDirective && this.taggingDirective == that.taggingDirective;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.source, this.metadataDirective, this.taggingDirective});
    }

    public static final class Builder
    extends ObjectWriteArgs.Builder<Builder, CopyObjectArgs> {
        @Override
        protected void validate(CopyObjectArgs args) {
            super.validate(args);
            this.validateNotNull(args.source, "copy source");
            if (args.source.offset() != null || args.source.length() != null) {
                if (args.metadataDirective != null && args.metadataDirective == Directive.COPY) {
                    throw new IllegalArgumentException("COPY metadata directive is not applicable to source object with range");
                }
                if (args.taggingDirective != null && args.taggingDirective == Directive.COPY) {
                    throw new IllegalArgumentException("COPY tagging directive is not applicable to source object with range");
                }
            }
        }

        public Builder source(CopySource source) {
            this.validateNotNull(source, "copy source");
            this.operations.add(args -> ((CopyObjectArgs)args).source = source);
            return this;
        }

        public Builder metadataDirective(Directive directive) {
            this.operations.add(args -> ((CopyObjectArgs)args).metadataDirective = directive);
            return this;
        }

        public Builder taggingDirective(Directive directive) {
            this.operations.add(args -> ((CopyObjectArgs)args).taggingDirective = directive);
            return this;
        }
    }
}

